package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OAuthClientBuilder extends io.fabric8.openshift.api.model.OAuthClientFluentImpl<io.fabric8.openshift.api.model.OAuthClientBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.OAuthClient,io.fabric8.openshift.api.model.OAuthClientBuilder> {

    io.fabric8.openshift.api.model.OAuthClientFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public OAuthClientBuilder() {
        this(true);
    }

    public OAuthClientBuilder(java.lang.Boolean validationEnabled) {
        this(new OAuthClient(), validationEnabled);
    }

    public OAuthClientBuilder(io.fabric8.openshift.api.model.OAuthClientFluent<?> fluent) {
        this(fluent, true);
    }

    public OAuthClientBuilder(io.fabric8.openshift.api.model.OAuthClientFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new OAuthClient(), validationEnabled);
    }

    public OAuthClientBuilder(io.fabric8.openshift.api.model.OAuthClientFluent<?> fluent,io.fabric8.openshift.api.model.OAuthClient instance) {
        this(fluent, instance, true);
    }

    public OAuthClientBuilder(io.fabric8.openshift.api.model.OAuthClientFluent<?> fluent,io.fabric8.openshift.api.model.OAuthClient instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
        fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
        fluent.withAdditionalSecrets(instance.getAdditionalSecrets()); 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withGrantMethod(instance.getGrantMethod()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withRedirectURIs(instance.getRedirectURIs()); 
        fluent.withRespondWithChallenges(instance.getRespondWithChallenges()); 
        fluent.withScopeRestrictions(instance.getScopeRestrictions()); 
        fluent.withSecret(instance.getSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public OAuthClientBuilder(io.fabric8.openshift.api.model.OAuthClient instance) {
        this(instance,true);
    }

    public OAuthClientBuilder(io.fabric8.openshift.api.model.OAuthClient instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
        this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
        this.withAdditionalSecrets(instance.getAdditionalSecrets()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withGrantMethod(instance.getGrantMethod()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withRedirectURIs(instance.getRedirectURIs()); 
        this.withRespondWithChallenges(instance.getRespondWithChallenges()); 
        this.withScopeRestrictions(instance.getScopeRestrictions()); 
        this.withSecret(instance.getSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.OAuthClient build() {
        OAuthClient buildable = new OAuthClient(fluent.getAccessTokenInactivityTimeoutSeconds(),fluent.getAccessTokenMaxAgeSeconds(),fluent.getAdditionalSecrets(),fluent.getApiVersion(),fluent.getGrantMethod(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURIs(),fluent.getRespondWithChallenges(),fluent.getScopeRestrictions(),fluent.getSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OAuthClientBuilder that = (OAuthClientBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
