package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OAuthClientListBuilder extends io.fabric8.openshift.api.model.OAuthClientListFluentImpl<io.fabric8.openshift.api.model.OAuthClientListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.OAuthClientList,io.fabric8.openshift.api.model.OAuthClientListBuilder> {

    io.fabric8.openshift.api.model.OAuthClientListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public OAuthClientListBuilder() {
        this(true);
    }

    public OAuthClientListBuilder(java.lang.Boolean validationEnabled) {
        this(new OAuthClientList(), validationEnabled);
    }

    public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientListFluent<?> fluent) {
        this(fluent, true);
    }

    public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new OAuthClientList(), validationEnabled);
    }

    public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientListFluent<?> fluent,io.fabric8.openshift.api.model.OAuthClientList instance) {
        this(fluent, instance, true);
    }

    public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientListFluent<?> fluent,io.fabric8.openshift.api.model.OAuthClientList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientList instance) {
        this(instance,true);
    }

    public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.OAuthClientList build() {
        OAuthClientList buildable = new OAuthClientList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OAuthClientListBuilder that = (OAuthClientListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
