package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class OAuthSpecFluentImpl<A extends io.fabric8.openshift.api.model.OAuthSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.OAuthSpecFluent<A> {

    private java.util.List<io.fabric8.openshift.api.model.IdentityProviderBuilder> identityProviders =  new java.util.ArrayList<io.fabric8.openshift.api.model.IdentityProviderBuilder>();
    private io.fabric8.openshift.api.model.OAuthTemplatesBuilder templates;
    private io.fabric8.openshift.api.model.TokenConfigBuilder tokenConfig;

    public OAuthSpecFluentImpl() {
    }

    public OAuthSpecFluentImpl(io.fabric8.openshift.api.model.OAuthSpec instance) {
        this.withIdentityProviders(instance.getIdentityProviders()); 
        this.withTemplates(instance.getTemplates()); 
        this.withTokenConfig(instance.getTokenConfig()); 
    }

    public A addToIdentityProviders(int index,io.fabric8.openshift.api.model.IdentityProvider item) {
        if (this.identityProviders == null) {this.identityProviders = new java.util.ArrayList<io.fabric8.openshift.api.model.IdentityProviderBuilder>();}
        io.fabric8.openshift.api.model.IdentityProviderBuilder builder = new io.fabric8.openshift.api.model.IdentityProviderBuilder(item);_visitables.get("identityProviders").add(index >= 0 ? index : _visitables.get("identityProviders").size(), builder);this.identityProviders.add(index >= 0 ? index : identityProviders.size(), builder); return (A)this;
    }

    public A setToIdentityProviders(int index,io.fabric8.openshift.api.model.IdentityProvider item) {
        if (this.identityProviders == null) {this.identityProviders = new java.util.ArrayList<io.fabric8.openshift.api.model.IdentityProviderBuilder>();}
        io.fabric8.openshift.api.model.IdentityProviderBuilder builder = new io.fabric8.openshift.api.model.IdentityProviderBuilder(item);
        if (index < 0 || index >= _visitables.get("identityProviders").size()) { _visitables.get("identityProviders").add(builder); } else { _visitables.get("identityProviders").set(index, builder);}
        if (index < 0 || index >= identityProviders.size()) { identityProviders.add(builder); } else { identityProviders.set(index, builder);}
         return (A)this;
    }

    public A addToIdentityProviders(io.fabric8.openshift.api.model.IdentityProvider... items) {
        if (this.identityProviders == null) {this.identityProviders = new java.util.ArrayList<io.fabric8.openshift.api.model.IdentityProviderBuilder>();}
        for (io.fabric8.openshift.api.model.IdentityProvider item : items) {io.fabric8.openshift.api.model.IdentityProviderBuilder builder = new io.fabric8.openshift.api.model.IdentityProviderBuilder(item);_visitables.get("identityProviders").add(builder);this.identityProviders.add(builder);} return (A)this;
    }

    public A addAllToIdentityProviders(java.util.Collection<io.fabric8.openshift.api.model.IdentityProvider> items) {
        if (this.identityProviders == null) {this.identityProviders = new java.util.ArrayList<io.fabric8.openshift.api.model.IdentityProviderBuilder>();}
        for (io.fabric8.openshift.api.model.IdentityProvider item : items) {io.fabric8.openshift.api.model.IdentityProviderBuilder builder = new io.fabric8.openshift.api.model.IdentityProviderBuilder(item);_visitables.get("identityProviders").add(builder);this.identityProviders.add(builder);} return (A)this;
    }

    public A removeFromIdentityProviders(io.fabric8.openshift.api.model.IdentityProvider... items) {
        for (io.fabric8.openshift.api.model.IdentityProvider item : items) {io.fabric8.openshift.api.model.IdentityProviderBuilder builder = new io.fabric8.openshift.api.model.IdentityProviderBuilder(item);_visitables.get("identityProviders").remove(builder);if (this.identityProviders != null) {this.identityProviders.remove(builder);}} return (A)this;
    }

    public A removeAllFromIdentityProviders(java.util.Collection<io.fabric8.openshift.api.model.IdentityProvider> items) {
        for (io.fabric8.openshift.api.model.IdentityProvider item : items) {io.fabric8.openshift.api.model.IdentityProviderBuilder builder = new io.fabric8.openshift.api.model.IdentityProviderBuilder(item);_visitables.get("identityProviders").remove(builder);if (this.identityProviders != null) {this.identityProviders.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIdentityProviders(java.util.function.Predicate<io.fabric8.openshift.api.model.IdentityProviderBuilder> predicate) {
        if (identityProviders == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.IdentityProviderBuilder> each = identityProviders.iterator();
        final List visitables = _visitables.get("identityProviders");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.IdentityProviderBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildIdentityProviders instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.IdentityProvider> getIdentityProviders() {
        return build(identityProviders);
    }

    public java.util.List<io.fabric8.openshift.api.model.IdentityProvider> buildIdentityProviders() {
        return build(identityProviders);
    }

    public io.fabric8.openshift.api.model.IdentityProvider buildIdentityProvider(int index) {
        return this.identityProviders.get(index).build();
    }

    public io.fabric8.openshift.api.model.IdentityProvider buildFirstIdentityProvider() {
        return this.identityProviders.get(0).build();
    }

    public io.fabric8.openshift.api.model.IdentityProvider buildLastIdentityProvider() {
        return this.identityProviders.get(identityProviders.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.IdentityProvider buildMatchingIdentityProvider(java.util.function.Predicate<io.fabric8.openshift.api.model.IdentityProviderBuilder> predicate) {
        for (io.fabric8.openshift.api.model.IdentityProviderBuilder item: identityProviders) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingIdentityProvider(java.util.function.Predicate<io.fabric8.openshift.api.model.IdentityProviderBuilder> predicate) {
        for (io.fabric8.openshift.api.model.IdentityProviderBuilder item: identityProviders) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIdentityProviders(java.util.List<io.fabric8.openshift.api.model.IdentityProvider> identityProviders) {
        if (this.identityProviders != null) { _visitables.get("identityProviders").removeAll(this.identityProviders);}
        if (identityProviders != null) {this.identityProviders = new java.util.ArrayList<io.fabric8.openshift.api.model.IdentityProviderBuilder>(); for (io.fabric8.openshift.api.model.IdentityProvider item : identityProviders){this.addToIdentityProviders(item);}} else { this.identityProviders = null;} return (A) this;
    }

    public A withIdentityProviders(io.fabric8.openshift.api.model.IdentityProvider... identityProviders) {
        if (this.identityProviders != null) {this.identityProviders.clear();}
        if (identityProviders != null) {for (io.fabric8.openshift.api.model.IdentityProvider item :identityProviders){ this.addToIdentityProviders(item);}} return (A) this;
    }

    public java.lang.Boolean hasIdentityProviders() {
        return identityProviders != null && !identityProviders.isEmpty();
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.IdentityProvidersNested<A> addNewIdentityProvider() {
        return new io.fabric8.openshift.api.model.OAuthSpecFluentImpl.IdentityProvidersNestedImpl();
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.IdentityProvidersNested<A> addNewIdentityProviderLike(io.fabric8.openshift.api.model.IdentityProvider item) {
        return new io.fabric8.openshift.api.model.OAuthSpecFluentImpl.IdentityProvidersNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.IdentityProvidersNested<A> setNewIdentityProviderLike(int index,io.fabric8.openshift.api.model.IdentityProvider item) {
        return new io.fabric8.openshift.api.model.OAuthSpecFluentImpl.IdentityProvidersNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.IdentityProvidersNested<A> editIdentityProvider(int index) {
        if (identityProviders.size() <= index) throw new RuntimeException("Can't edit identityProviders. Index exceeds size.");
        return setNewIdentityProviderLike(index, buildIdentityProvider(index));
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.IdentityProvidersNested<A> editFirstIdentityProvider() {
        if (identityProviders.size() == 0) throw new RuntimeException("Can't edit first identityProviders. The list is empty.");
        return setNewIdentityProviderLike(0, buildIdentityProvider(0));
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.IdentityProvidersNested<A> editLastIdentityProvider() {
        int index = identityProviders.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last identityProviders. The list is empty.");
        return setNewIdentityProviderLike(index, buildIdentityProvider(index));
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.IdentityProvidersNested<A> editMatchingIdentityProvider(java.util.function.Predicate<io.fabric8.openshift.api.model.IdentityProviderBuilder> predicate) {
        int index = -1;
        for (int i=0;i<identityProviders.size();i++) { 
        if (predicate.test(identityProviders.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching identityProviders. No match found.");
        return setNewIdentityProviderLike(index, buildIdentityProvider(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplates instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.OAuthTemplates getTemplates() {
        return this.templates!=null?this.templates.build():null;
    }

    public io.fabric8.openshift.api.model.OAuthTemplates buildTemplates() {
        return this.templates!=null?this.templates.build():null;
    }

    public A withTemplates(io.fabric8.openshift.api.model.OAuthTemplates templates) {
        _visitables.get("templates").remove(this.templates);
        if (templates!=null){ this.templates= new io.fabric8.openshift.api.model.OAuthTemplatesBuilder(templates); _visitables.get("templates").add(this.templates);} return (A) this;
    }

    public java.lang.Boolean hasTemplates() {
        return this.templates != null;
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.TemplatesNested<A> withNewTemplates() {
        return new io.fabric8.openshift.api.model.OAuthSpecFluentImpl.TemplatesNestedImpl();
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.TemplatesNested<A> withNewTemplatesLike(io.fabric8.openshift.api.model.OAuthTemplates item) {
        return new io.fabric8.openshift.api.model.OAuthSpecFluentImpl.TemplatesNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.TemplatesNested<A> editTemplates() {
        return withNewTemplatesLike(getTemplates());
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.TemplatesNested<A> editOrNewTemplates() {
        return withNewTemplatesLike(getTemplates() != null ? getTemplates(): new io.fabric8.openshift.api.model.OAuthTemplatesBuilder().build());
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.TemplatesNested<A> editOrNewTemplatesLike(io.fabric8.openshift.api.model.OAuthTemplates item) {
        return withNewTemplatesLike(getTemplates() != null ? getTemplates(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTokenConfig instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.TokenConfig getTokenConfig() {
        return this.tokenConfig!=null?this.tokenConfig.build():null;
    }

    public io.fabric8.openshift.api.model.TokenConfig buildTokenConfig() {
        return this.tokenConfig!=null?this.tokenConfig.build():null;
    }

    public A withTokenConfig(io.fabric8.openshift.api.model.TokenConfig tokenConfig) {
        _visitables.get("tokenConfig").remove(this.tokenConfig);
        if (tokenConfig!=null){ this.tokenConfig= new io.fabric8.openshift.api.model.TokenConfigBuilder(tokenConfig); _visitables.get("tokenConfig").add(this.tokenConfig);} return (A) this;
    }

    public java.lang.Boolean hasTokenConfig() {
        return this.tokenConfig != null;
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.TokenConfigNested<A> withNewTokenConfig() {
        return new io.fabric8.openshift.api.model.OAuthSpecFluentImpl.TokenConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.TokenConfigNested<A> withNewTokenConfigLike(io.fabric8.openshift.api.model.TokenConfig item) {
        return new io.fabric8.openshift.api.model.OAuthSpecFluentImpl.TokenConfigNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.TokenConfigNested<A> editTokenConfig() {
        return withNewTokenConfigLike(getTokenConfig());
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.TokenConfigNested<A> editOrNewTokenConfig() {
        return withNewTokenConfigLike(getTokenConfig() != null ? getTokenConfig(): new io.fabric8.openshift.api.model.TokenConfigBuilder().build());
    }

    public io.fabric8.openshift.api.model.OAuthSpecFluent.TokenConfigNested<A> editOrNewTokenConfigLike(io.fabric8.openshift.api.model.TokenConfig item) {
        return withNewTokenConfigLike(getTokenConfig() != null ? getTokenConfig(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OAuthSpecFluentImpl that = (OAuthSpecFluentImpl) o;
        if (identityProviders != null ? !identityProviders.equals(that.identityProviders) :that.identityProviders != null) return false;
        if (templates != null ? !templates.equals(that.templates) :that.templates != null) return false;
        if (tokenConfig != null ? !tokenConfig.equals(that.tokenConfig) :that.tokenConfig != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(identityProviders,  templates,  tokenConfig,  super.hashCode());
    }

    public class IdentityProvidersNestedImpl<N> extends io.fabric8.openshift.api.model.IdentityProviderFluentImpl<io.fabric8.openshift.api.model.OAuthSpecFluent.IdentityProvidersNested<N>> implements io.fabric8.openshift.api.model.OAuthSpecFluent.IdentityProvidersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.IdentityProviderBuilder builder;
        private final int index;

            IdentityProvidersNestedImpl(int index,io.fabric8.openshift.api.model.IdentityProvider item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.IdentityProviderBuilder(this, item);
                        
            }

            IdentityProvidersNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.IdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) OAuthSpecFluentImpl.this.setToIdentityProviders(index,builder.build());
            }

            public N endIdentityProvider() {
                return and();
            }
    }


    public class TemplatesNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthTemplatesFluentImpl<io.fabric8.openshift.api.model.OAuthSpecFluent.TemplatesNested<N>> implements io.fabric8.openshift.api.model.OAuthSpecFluent.TemplatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.OAuthTemplatesBuilder builder;

            TemplatesNestedImpl(io.fabric8.openshift.api.model.OAuthTemplates item) {
                this.builder = new io.fabric8.openshift.api.model.OAuthTemplatesBuilder(this, item);
                        
            }

            TemplatesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.OAuthTemplatesBuilder(this);
                        
            }

            public N and() {
                return (N) OAuthSpecFluentImpl.this.withTemplates(builder.build());
            }

            public N endTemplates() {
                return and();
            }
    }


    public class TokenConfigNestedImpl<N> extends io.fabric8.openshift.api.model.TokenConfigFluentImpl<io.fabric8.openshift.api.model.OAuthSpecFluent.TokenConfigNested<N>> implements io.fabric8.openshift.api.model.OAuthSpecFluent.TokenConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.TokenConfigBuilder builder;

            TokenConfigNestedImpl(io.fabric8.openshift.api.model.TokenConfig item) {
                this.builder = new io.fabric8.openshift.api.model.TokenConfigBuilder(this, item);
                        
            }

            TokenConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.TokenConfigBuilder(this);
                        
            }

            public N and() {
                return (N) OAuthSpecFluentImpl.this.withTokenConfig(builder.build());
            }

            public N endTokenConfig() {
                return and();
            }
    }


}
