package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorHubListBuilder extends io.fabric8.openshift.api.model.OperatorHubListFluentImpl<io.fabric8.openshift.api.model.OperatorHubListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.OperatorHubList,io.fabric8.openshift.api.model.OperatorHubListBuilder> {

    io.fabric8.openshift.api.model.OperatorHubListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public OperatorHubListBuilder() {
        this(true);
    }

    public OperatorHubListBuilder(java.lang.Boolean validationEnabled) {
        this(new OperatorHubList(), validationEnabled);
    }

    public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubListFluent<?> fluent) {
        this(fluent, true);
    }

    public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new OperatorHubList(), validationEnabled);
    }

    public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubListFluent<?> fluent,io.fabric8.openshift.api.model.OperatorHubList instance) {
        this(fluent, instance, true);
    }

    public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubListFluent<?> fluent,io.fabric8.openshift.api.model.OperatorHubList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubList instance) {
        this(instance,true);
    }

    public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.OperatorHubList build() {
        OperatorHubList buildable = new OperatorHubList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OperatorHubListBuilder that = (OperatorHubListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
