package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OvirtPlatformStatusBuilder extends io.fabric8.openshift.api.model.OvirtPlatformStatusFluentImpl<io.fabric8.openshift.api.model.OvirtPlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.OvirtPlatformStatus,io.fabric8.openshift.api.model.OvirtPlatformStatusBuilder> {

    io.fabric8.openshift.api.model.OvirtPlatformStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public OvirtPlatformStatusBuilder() {
        this(true);
    }

    public OvirtPlatformStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new OvirtPlatformStatus(), validationEnabled);
    }

    public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new OvirtPlatformStatus(), validationEnabled);
    }

    public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.OvirtPlatformStatus instance) {
        this(fluent, instance, true);
    }

    public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.OvirtPlatformStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        fluent.withIngressIP(instance.getIngressIP()); 
        fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatus instance) {
        this(instance,true);
    }

    public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        this.withIngressIP(instance.getIngressIP()); 
        this.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.OvirtPlatformStatus build() {
        OvirtPlatformStatus buildable = new OvirtPlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP(),fluent.getNodeDNSIP());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OvirtPlatformStatusBuilder that = (OvirtPlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
