package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PolicyRuleBuilder extends io.fabric8.openshift.api.model.PolicyRuleFluentImpl<io.fabric8.openshift.api.model.PolicyRuleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.PolicyRule,io.fabric8.openshift.api.model.PolicyRuleBuilder> {

    io.fabric8.openshift.api.model.PolicyRuleFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PolicyRuleBuilder() {
        this(true);
    }

    public PolicyRuleBuilder(java.lang.Boolean validationEnabled) {
        this(new PolicyRule(), validationEnabled);
    }

    public PolicyRuleBuilder(io.fabric8.openshift.api.model.PolicyRuleFluent<?> fluent) {
        this(fluent, true);
    }

    public PolicyRuleBuilder(io.fabric8.openshift.api.model.PolicyRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PolicyRule(), validationEnabled);
    }

    public PolicyRuleBuilder(io.fabric8.openshift.api.model.PolicyRuleFluent<?> fluent,io.fabric8.openshift.api.model.PolicyRule instance) {
        this(fluent, instance, true);
    }

    public PolicyRuleBuilder(io.fabric8.openshift.api.model.PolicyRuleFluent<?> fluent,io.fabric8.openshift.api.model.PolicyRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiGroups(instance.getApiGroups()); 
        fluent.withAttributeRestrictions(instance.getAttributeRestrictions()); 
        fluent.withNonResourceURLs(instance.getNonResourceURLs()); 
        fluent.withResourceNames(instance.getResourceNames()); 
        fluent.withResources(instance.getResources()); 
        fluent.withVerbs(instance.getVerbs()); 
        this.validationEnabled = validationEnabled; 
    }

    public PolicyRuleBuilder(io.fabric8.openshift.api.model.PolicyRule instance) {
        this(instance,true);
    }

    public PolicyRuleBuilder(io.fabric8.openshift.api.model.PolicyRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiGroups(instance.getApiGroups()); 
        this.withAttributeRestrictions(instance.getAttributeRestrictions()); 
        this.withNonResourceURLs(instance.getNonResourceURLs()); 
        this.withResourceNames(instance.getResourceNames()); 
        this.withResources(instance.getResources()); 
        this.withVerbs(instance.getVerbs()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.PolicyRule build() {
        PolicyRule buildable = new PolicyRule(fluent.getApiGroups(),fluent.getAttributeRestrictions(),fluent.getNonResourceURLs(),fluent.getResourceNames(),fluent.getResources(),fluent.getVerbs());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PolicyRuleBuilder that = (PolicyRuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
