package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProxyStatusBuilder extends io.fabric8.openshift.api.model.ProxyStatusFluentImpl<io.fabric8.openshift.api.model.ProxyStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ProxyStatus,io.fabric8.openshift.api.model.ProxyStatusBuilder> {

    io.fabric8.openshift.api.model.ProxyStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ProxyStatusBuilder() {
        this(true);
    }

    public ProxyStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ProxyStatus(), validationEnabled);
    }

    public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ProxyStatus(), validationEnabled);
    }

    public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatusFluent<?> fluent,io.fabric8.openshift.api.model.ProxyStatus instance) {
        this(fluent, instance, true);
    }

    public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatusFluent<?> fluent,io.fabric8.openshift.api.model.ProxyStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHttpProxy(instance.getHttpProxy()); 
        fluent.withHttpsProxy(instance.getHttpsProxy()); 
        fluent.withNoProxy(instance.getNoProxy()); 
        this.validationEnabled = validationEnabled; 
    }

    public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatus instance) {
        this(instance,true);
    }

    public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHttpProxy(instance.getHttpProxy()); 
        this.withHttpsProxy(instance.getHttpsProxy()); 
        this.withNoProxy(instance.getNoProxy()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ProxyStatus build() {
        ProxyStatus buildable = new ProxyStatus(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProxyStatusBuilder that = (ProxyStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
