package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RangeAllocationListBuilder extends io.fabric8.openshift.api.model.RangeAllocationListFluentImpl<io.fabric8.openshift.api.model.RangeAllocationListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.RangeAllocationList,io.fabric8.openshift.api.model.RangeAllocationListBuilder> {

    io.fabric8.openshift.api.model.RangeAllocationListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RangeAllocationListBuilder() {
        this(true);
    }

    public RangeAllocationListBuilder(java.lang.Boolean validationEnabled) {
        this(new RangeAllocationList(), validationEnabled);
    }

    public RangeAllocationListBuilder(io.fabric8.openshift.api.model.RangeAllocationListFluent<?> fluent) {
        this(fluent, true);
    }

    public RangeAllocationListBuilder(io.fabric8.openshift.api.model.RangeAllocationListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RangeAllocationList(), validationEnabled);
    }

    public RangeAllocationListBuilder(io.fabric8.openshift.api.model.RangeAllocationListFluent<?> fluent,io.fabric8.openshift.api.model.RangeAllocationList instance) {
        this(fluent, instance, true);
    }

    public RangeAllocationListBuilder(io.fabric8.openshift.api.model.RangeAllocationListFluent<?> fluent,io.fabric8.openshift.api.model.RangeAllocationList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public RangeAllocationListBuilder(io.fabric8.openshift.api.model.RangeAllocationList instance) {
        this(instance,true);
    }

    public RangeAllocationListBuilder(io.fabric8.openshift.api.model.RangeAllocationList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.RangeAllocationList build() {
        RangeAllocationList buildable = new RangeAllocationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RangeAllocationListBuilder that = (RangeAllocationListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
