package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceAccountRestrictionBuilder extends io.fabric8.openshift.api.model.ServiceAccountRestrictionFluentImpl<io.fabric8.openshift.api.model.ServiceAccountRestrictionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ServiceAccountRestriction,io.fabric8.openshift.api.model.ServiceAccountRestrictionBuilder> {

    io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServiceAccountRestrictionBuilder() {
        this(true);
    }

    public ServiceAccountRestrictionBuilder(java.lang.Boolean validationEnabled) {
        this(new ServiceAccountRestriction(), validationEnabled);
    }

    public ServiceAccountRestrictionBuilder(io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceAccountRestrictionBuilder(io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ServiceAccountRestriction(), validationEnabled);
    }

    public ServiceAccountRestrictionBuilder(io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent<?> fluent,io.fabric8.openshift.api.model.ServiceAccountRestriction instance) {
        this(fluent, instance, true);
    }

    public ServiceAccountRestrictionBuilder(io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent<?> fluent,io.fabric8.openshift.api.model.ServiceAccountRestriction instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNamespaces(instance.getNamespaces()); 
        fluent.withServiceaccounts(instance.getServiceaccounts()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceAccountRestrictionBuilder(io.fabric8.openshift.api.model.ServiceAccountRestriction instance) {
        this(instance,true);
    }

    public ServiceAccountRestrictionBuilder(io.fabric8.openshift.api.model.ServiceAccountRestriction instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withNamespaces(instance.getNamespaces()); 
        this.withServiceaccounts(instance.getServiceaccounts()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ServiceAccountRestriction build() {
        ServiceAccountRestriction buildable = new ServiceAccountRestriction(fluent.getNamespaces(),fluent.getServiceaccounts());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceAccountRestrictionBuilder that = (ServiceAccountRestrictionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
