package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SignatureIssuerBuilder extends io.fabric8.openshift.api.model.SignatureIssuerFluentImpl<io.fabric8.openshift.api.model.SignatureIssuerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.SignatureIssuer,io.fabric8.openshift.api.model.SignatureIssuerBuilder> {

    io.fabric8.openshift.api.model.SignatureIssuerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public SignatureIssuerBuilder() {
        this(true);
    }

    public SignatureIssuerBuilder(java.lang.Boolean validationEnabled) {
        this(new SignatureIssuer(), validationEnabled);
    }

    public SignatureIssuerBuilder(io.fabric8.openshift.api.model.SignatureIssuerFluent<?> fluent) {
        this(fluent, true);
    }

    public SignatureIssuerBuilder(io.fabric8.openshift.api.model.SignatureIssuerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new SignatureIssuer(), validationEnabled);
    }

    public SignatureIssuerBuilder(io.fabric8.openshift.api.model.SignatureIssuerFluent<?> fluent,io.fabric8.openshift.api.model.SignatureIssuer instance) {
        this(fluent, instance, true);
    }

    public SignatureIssuerBuilder(io.fabric8.openshift.api.model.SignatureIssuerFluent<?> fluent,io.fabric8.openshift.api.model.SignatureIssuer instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCommonName(instance.getCommonName()); 
        fluent.withOrganization(instance.getOrganization()); 
        this.validationEnabled = validationEnabled; 
    }

    public SignatureIssuerBuilder(io.fabric8.openshift.api.model.SignatureIssuer instance) {
        this(instance,true);
    }

    public SignatureIssuerBuilder(io.fabric8.openshift.api.model.SignatureIssuer instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCommonName(instance.getCommonName()); 
        this.withOrganization(instance.getOrganization()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.SignatureIssuer build() {
        SignatureIssuer buildable = new SignatureIssuer(fluent.getCommonName(),fluent.getOrganization());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SignatureIssuerBuilder that = (SignatureIssuerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
