package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TemplateInstanceSpecBuilder extends io.fabric8.openshift.api.model.TemplateInstanceSpecFluentImpl<io.fabric8.openshift.api.model.TemplateInstanceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.TemplateInstanceSpec,io.fabric8.openshift.api.model.TemplateInstanceSpecBuilder> {

    io.fabric8.openshift.api.model.TemplateInstanceSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TemplateInstanceSpecBuilder() {
        this(true);
    }

    public TemplateInstanceSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new TemplateInstanceSpec(), validationEnabled);
    }

    public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TemplateInstanceSpec(), validationEnabled);
    }

    public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpecFluent<?> fluent,io.fabric8.openshift.api.model.TemplateInstanceSpec instance) {
        this(fluent, instance, true);
    }

    public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpecFluent<?> fluent,io.fabric8.openshift.api.model.TemplateInstanceSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withRequester(instance.getRequester()); 
        fluent.withSecret(instance.getSecret()); 
        fluent.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpec instance) {
        this(instance,true);
    }

    public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withRequester(instance.getRequester()); 
        this.withSecret(instance.getSecret()); 
        this.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.TemplateInstanceSpec build() {
        TemplateInstanceSpec buildable = new TemplateInstanceSpec(fluent.getRequester(),fluent.getSecret(),fluent.getTemplate());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TemplateInstanceSpecBuilder that = (TemplateInstanceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
