package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class UserOAuthAccessTokenBuilder extends io.fabric8.openshift.api.model.UserOAuthAccessTokenFluentImpl<io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.UserOAuthAccessToken,io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder> {

    io.fabric8.openshift.api.model.UserOAuthAccessTokenFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public UserOAuthAccessTokenBuilder() {
        this(true);
    }

    public UserOAuthAccessTokenBuilder(java.lang.Boolean validationEnabled) {
        this(new UserOAuthAccessToken(), validationEnabled);
    }

    public UserOAuthAccessTokenBuilder(io.fabric8.openshift.api.model.UserOAuthAccessTokenFluent<?> fluent) {
        this(fluent, true);
    }

    public UserOAuthAccessTokenBuilder(io.fabric8.openshift.api.model.UserOAuthAccessTokenFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new UserOAuthAccessToken(), validationEnabled);
    }

    public UserOAuthAccessTokenBuilder(io.fabric8.openshift.api.model.UserOAuthAccessTokenFluent<?> fluent,io.fabric8.openshift.api.model.UserOAuthAccessToken instance) {
        this(fluent, instance, true);
    }

    public UserOAuthAccessTokenBuilder(io.fabric8.openshift.api.model.UserOAuthAccessTokenFluent<?> fluent,io.fabric8.openshift.api.model.UserOAuthAccessToken instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withAuthorizeToken(instance.getAuthorizeToken()); 
        fluent.withClientName(instance.getClientName()); 
        fluent.withExpiresIn(instance.getExpiresIn()); 
        fluent.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withRedirectURI(instance.getRedirectURI()); 
        fluent.withRefreshToken(instance.getRefreshToken()); 
        fluent.withScopes(instance.getScopes()); 
        fluent.withUserName(instance.getUserName()); 
        fluent.withUserUID(instance.getUserUID()); 
        this.validationEnabled = validationEnabled; 
    }

    public UserOAuthAccessTokenBuilder(io.fabric8.openshift.api.model.UserOAuthAccessToken instance) {
        this(instance,true);
    }

    public UserOAuthAccessTokenBuilder(io.fabric8.openshift.api.model.UserOAuthAccessToken instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withAuthorizeToken(instance.getAuthorizeToken()); 
        this.withClientName(instance.getClientName()); 
        this.withExpiresIn(instance.getExpiresIn()); 
        this.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withRedirectURI(instance.getRedirectURI()); 
        this.withRefreshToken(instance.getRefreshToken()); 
        this.withScopes(instance.getScopes()); 
        this.withUserName(instance.getUserName()); 
        this.withUserUID(instance.getUserUID()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.UserOAuthAccessToken build() {
        UserOAuthAccessToken buildable = new UserOAuthAccessToken(fluent.getApiVersion(),fluent.getAuthorizeToken(),fluent.getClientName(),fluent.getExpiresIn(),fluent.getInactivityTimeoutSeconds(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURI(),fluent.getRefreshToken(),fluent.getScopes(),fluent.getUserName(),fluent.getUserUID());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        UserOAuthAccessTokenBuilder that = (UserOAuthAccessTokenBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
