package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class WebhookTokenAuthenticatorBuilder extends io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluentImpl<io.fabric8.openshift.api.model.WebhookTokenAuthenticatorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.WebhookTokenAuthenticator,io.fabric8.openshift.api.model.WebhookTokenAuthenticatorBuilder> {

    io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public WebhookTokenAuthenticatorBuilder() {
        this(true);
    }

    public WebhookTokenAuthenticatorBuilder(java.lang.Boolean validationEnabled) {
        this(new WebhookTokenAuthenticator(), validationEnabled);
    }

    public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluent<?> fluent) {
        this(fluent, true);
    }

    public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new WebhookTokenAuthenticator(), validationEnabled);
    }

    public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluent<?> fluent,io.fabric8.openshift.api.model.WebhookTokenAuthenticator instance) {
        this(fluent, instance, true);
    }

    public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluent<?> fluent,io.fabric8.openshift.api.model.WebhookTokenAuthenticator instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withKubeConfig(instance.getKubeConfig()); 
        this.validationEnabled = validationEnabled; 
    }

    public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticator instance) {
        this(instance,true);
    }

    public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticator instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withKubeConfig(instance.getKubeConfig()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.WebhookTokenAuthenticator build() {
        WebhookTokenAuthenticator buildable = new WebhookTokenAuthenticator(fluent.getKubeConfig());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        WebhookTokenAuthenticatorBuilder that = (WebhookTokenAuthenticatorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
