/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.ClusterNetworkEntryFluentImpl;
import io.fabric8.openshift.api.model.NetworkMigration;
import io.fabric8.openshift.api.model.NetworkMigrationBuilder;
import io.fabric8.openshift.api.model.NetworkMigrationFluentImpl;
import io.fabric8.openshift.api.model.NetworkStatus;
import io.fabric8.openshift.api.model.NetworkStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkStatusFluentImpl<A extends NetworkStatusFluent<A>>
extends BaseFluent<A>
implements NetworkStatusFluent<A> {
    private List<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
    private Integer clusterNetworkMTU;
    private NetworkMigrationBuilder migration;
    private String networkType;
    private List<String> serviceNetwork = new ArrayList<String>();

    public NetworkStatusFluentImpl() {
    }

    public NetworkStatusFluentImpl(NetworkStatus instance) {
        this.withClusterNetwork(instance.getClusterNetwork());
        this.withClusterNetworkMTU(instance.getClusterNetworkMTU());
        this.withMigration(instance.getMigration());
        this.withNetworkType(instance.getNetworkType());
        this.withServiceNetwork(instance.getServiceNetwork());
    }

    @Override
    public A addToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        this._visitables.get((Object)"clusterNetwork").add(index >= 0 ? index : this._visitables.get((Object)"clusterNetwork").size(), builder);
        this.clusterNetwork.add(index >= 0 ? index : this.clusterNetwork.size(), builder);
        return (A)this;
    }

    @Override
    public A setToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"clusterNetwork").size()) {
            this._visitables.get((Object)"clusterNetwork").add(builder);
        } else {
            this._visitables.get((Object)"clusterNetwork").set(index, builder);
        }
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this.clusterNetwork.add(builder);
        } else {
            this.clusterNetwork.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterNetwork(ClusterNetworkEntry ... items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").remove(builder);
            if (this.clusterNetwork == null) continue;
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").remove(builder);
            if (this.clusterNetwork == null) continue;
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.clusterNetwork.iterator();
        List visitables = this._visitables.get((Object)"clusterNetwork");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterNetworkEntry> getClusterNetwork() {
        return NetworkStatusFluentImpl.build(this.clusterNetwork);
    }

    @Override
    public List<ClusterNetworkEntry> buildClusterNetwork() {
        return NetworkStatusFluentImpl.build(this.clusterNetwork);
    }

    @Override
    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetwork.get(index).build();
    }

    @Override
    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetwork.get(0).build();
    }

    @Override
    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetwork.get(this.clusterNetwork.size() - 1).build();
    }

    @Override
    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
        if (this.clusterNetwork != null) {
            this._visitables.get((Object)"clusterNetwork").removeAll(this.clusterNetwork);
        }
        if (clusterNetwork != null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        } else {
            this.clusterNetwork = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterNetwork(ClusterNetworkEntry ... clusterNetwork) {
        if (this.clusterNetwork != null) {
            this.clusterNetwork.clear();
        }
        if (clusterNetwork != null) {
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterNetwork() {
        return this.clusterNetwork != null && !this.clusterNetwork.isEmpty();
    }

    @Override
    public A addNewClusterNetwork(String cidr, Integer hostSubnetLength) {
        return this.addToClusterNetwork(new ClusterNetworkEntry(cidr, hostSubnetLength));
    }

    @Override
    public NetworkStatusFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
        return new ClusterNetworkNestedImpl();
    }

    @Override
    public NetworkStatusFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworkNestedImpl(-1, item);
    }

    @Override
    public NetworkStatusFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new ClusterNetworkNestedImpl(index, item);
    }

    @Override
    public NetworkStatusFluent.ClusterNetworkNested<A> editClusterNetwork(int index) {
        if (this.clusterNetwork.size() <= index) {
            throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public NetworkStatusFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
        if (this.clusterNetwork.size() == 0) {
            throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(0, this.buildClusterNetwork(0));
    }

    @Override
    public NetworkStatusFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
        int index = this.clusterNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public NetworkStatusFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterNetwork.size(); ++i) {
            if (!predicate.test(this.clusterNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public Integer getClusterNetworkMTU() {
        return this.clusterNetworkMTU;
    }

    @Override
    public A withClusterNetworkMTU(Integer clusterNetworkMTU) {
        this.clusterNetworkMTU = clusterNetworkMTU;
        return (A)this;
    }

    @Override
    public Boolean hasClusterNetworkMTU() {
        return this.clusterNetworkMTU != null;
    }

    @Override
    @Deprecated
    public NetworkMigration getMigration() {
        return this.migration != null ? this.migration.build() : null;
    }

    @Override
    public NetworkMigration buildMigration() {
        return this.migration != null ? this.migration.build() : null;
    }

    @Override
    public A withMigration(NetworkMigration migration) {
        this._visitables.get((Object)"migration").remove(this.migration);
        if (migration != null) {
            this.migration = new NetworkMigrationBuilder(migration);
            this._visitables.get((Object)"migration").add(this.migration);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMigration() {
        return this.migration != null;
    }

    @Override
    public A withNewMigration(String networkType) {
        return this.withMigration(new NetworkMigration(networkType));
    }

    @Override
    public NetworkStatusFluent.MigrationNested<A> withNewMigration() {
        return new MigrationNestedImpl();
    }

    @Override
    public NetworkStatusFluent.MigrationNested<A> withNewMigrationLike(NetworkMigration item) {
        return new MigrationNestedImpl(item);
    }

    @Override
    public NetworkStatusFluent.MigrationNested<A> editMigration() {
        return this.withNewMigrationLike(this.getMigration());
    }

    @Override
    public NetworkStatusFluent.MigrationNested<A> editOrNewMigration() {
        return this.withNewMigrationLike(this.getMigration() != null ? this.getMigration() : new NetworkMigrationBuilder().build());
    }

    @Override
    public NetworkStatusFluent.MigrationNested<A> editOrNewMigrationLike(NetworkMigration item) {
        return this.withNewMigrationLike(this.getMigration() != null ? this.getMigration() : item);
    }

    @Override
    public String getNetworkType() {
        return this.networkType;
    }

    @Override
    public A withNetworkType(String networkType) {
        this.networkType = networkType;
        return (A)this;
    }

    @Override
    public Boolean hasNetworkType() {
        return this.networkType != null;
    }

    @Override
    @Deprecated
    public A withNewNetworkType(String arg0) {
        return this.withNetworkType(new String(arg0));
    }

    @Override
    public A addToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceNetwork(String ... items) {
        for (String item : items) {
            if (this.serviceNetwork == null) continue;
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceNetwork(Collection<String> items) {
        for (String item : items) {
            if (this.serviceNetwork == null) continue;
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServiceNetwork() {
        return this.serviceNetwork;
    }

    @Override
    public String getServiceNetwork(int index) {
        return this.serviceNetwork.get(index);
    }

    @Override
    public String getFirstServiceNetwork() {
        return this.serviceNetwork.get(0);
    }

    @Override
    public String getLastServiceNetwork() {
        return this.serviceNetwork.get(this.serviceNetwork.size() - 1);
    }

    @Override
    public String getMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceNetwork(List<String> serviceNetwork) {
        if (this.serviceNetwork != null) {
            this._visitables.get((Object)"serviceNetwork").removeAll(this.serviceNetwork);
        }
        if (serviceNetwork != null) {
            this.serviceNetwork = new ArrayList<String>();
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        } else {
            this.serviceNetwork = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceNetwork(String ... serviceNetwork) {
        if (this.serviceNetwork != null) {
            this.serviceNetwork.clear();
        }
        if (serviceNetwork != null) {
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceNetwork() {
        return this.serviceNetwork != null && !this.serviceNetwork.isEmpty();
    }

    @Override
    public A addNewServiceNetwork(String arg0) {
        return this.addToServiceNetwork(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkStatusFluentImpl that = (NetworkStatusFluentImpl)o;
        if (this.clusterNetwork != null ? !this.clusterNetwork.equals(that.clusterNetwork) : that.clusterNetwork != null) {
            return false;
        }
        if (this.clusterNetworkMTU != null ? !this.clusterNetworkMTU.equals(that.clusterNetworkMTU) : that.clusterNetworkMTU != null) {
            return false;
        }
        if (this.migration != null ? !this.migration.equals(that.migration) : that.migration != null) {
            return false;
        }
        if (this.networkType != null ? !this.networkType.equals(that.networkType) : that.networkType != null) {
            return false;
        }
        return !(this.serviceNetwork != null ? !this.serviceNetwork.equals(that.serviceNetwork) : that.serviceNetwork != null);
    }

    public int hashCode() {
        return Objects.hash(this.clusterNetwork, this.clusterNetworkMTU, this.migration, this.networkType, this.serviceNetwork, super.hashCode());
    }

    public class MigrationNestedImpl<N>
    extends NetworkMigrationFluentImpl<NetworkStatusFluent.MigrationNested<N>>
    implements NetworkStatusFluent.MigrationNested<N>,
    Nested<N> {
        private final NetworkMigrationBuilder builder;

        MigrationNestedImpl(NetworkMigration item) {
            this.builder = new NetworkMigrationBuilder(this, item);
        }

        MigrationNestedImpl() {
            this.builder = new NetworkMigrationBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkStatusFluentImpl.this.withMigration(this.builder.build());
        }

        @Override
        public N endMigration() {
            return this.and();
        }
    }

    public class ClusterNetworkNestedImpl<N>
    extends ClusterNetworkEntryFluentImpl<NetworkStatusFluent.ClusterNetworkNested<N>>
    implements NetworkStatusFluent.ClusterNetworkNested<N>,
    Nested<N> {
        private final ClusterNetworkEntryBuilder builder;
        private final int index;

        ClusterNetworkNestedImpl(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        ClusterNetworkNestedImpl() {
            this.index = -1;
            this.builder = new ClusterNetworkEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkStatusFluentImpl.this.setToClusterNetwork(this.index, this.builder.build());
        }

        @Override
        public N endClusterNetwork() {
            return this.and();
        }
    }
}

