package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildConfigStatusBuilder extends io.fabric8.openshift.api.model.BuildConfigStatusFluentImpl<io.fabric8.openshift.api.model.BuildConfigStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.BuildConfigStatus,io.fabric8.openshift.api.model.BuildConfigStatusBuilder> {

    io.fabric8.openshift.api.model.BuildConfigStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BuildConfigStatusBuilder() {
        this(true);
    }

    public BuildConfigStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new BuildConfigStatus(), validationEnabled);
    }

    public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new BuildConfigStatus(), validationEnabled);
    }

    public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatusFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfigStatus instance) {
        this(fluent, instance, true);
    }

    public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatusFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfigStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withImageChangeTriggers(instance.getImageChangeTriggers()); 
        fluent.withLastVersion(instance.getLastVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatus instance) {
        this(instance,true);
    }

    public BuildConfigStatusBuilder(io.fabric8.openshift.api.model.BuildConfigStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withImageChangeTriggers(instance.getImageChangeTriggers()); 
        this.withLastVersion(instance.getLastVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.BuildConfigStatus build() {
        BuildConfigStatus buildable = new BuildConfigStatus(fluent.getImageChangeTriggers(),fluent.getLastVersion());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildConfigStatusBuilder that = (BuildConfigStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
