package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterResourceQuotaListBuilder extends io.fabric8.openshift.api.model.ClusterResourceQuotaListFluentImpl<io.fabric8.openshift.api.model.ClusterResourceQuotaListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ClusterResourceQuotaList,io.fabric8.openshift.api.model.ClusterResourceQuotaListBuilder> {

    io.fabric8.openshift.api.model.ClusterResourceQuotaListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClusterResourceQuotaListBuilder() {
        this(true);
    }

    public ClusterResourceQuotaListBuilder(java.lang.Boolean validationEnabled) {
        this(new ClusterResourceQuotaList(), validationEnabled);
    }

    public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaListFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClusterResourceQuotaList(), validationEnabled);
    }

    public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuotaList instance) {
        this(fluent, instance, true);
    }

    public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuotaList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaList instance) {
        this(instance,true);
    }

    public ClusterResourceQuotaListBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ClusterResourceQuotaList build() {
        ClusterResourceQuotaList buildable = new ClusterResourceQuotaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterResourceQuotaListBuilder that = (ClusterResourceQuotaListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
