package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CustomBuildStrategyBuilder extends io.fabric8.openshift.api.model.CustomBuildStrategyFluentImpl<io.fabric8.openshift.api.model.CustomBuildStrategyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.CustomBuildStrategy,io.fabric8.openshift.api.model.CustomBuildStrategyBuilder> {

    io.fabric8.openshift.api.model.CustomBuildStrategyFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CustomBuildStrategyBuilder() {
        this(true);
    }

    public CustomBuildStrategyBuilder(java.lang.Boolean validationEnabled) {
        this(new CustomBuildStrategy(), validationEnabled);
    }

    public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategyFluent<?> fluent) {
        this(fluent, true);
    }

    public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CustomBuildStrategy(), validationEnabled);
    }

    public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.CustomBuildStrategy instance) {
        this(fluent, instance, true);
    }

    public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.CustomBuildStrategy instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBuildAPIVersion(instance.getBuildAPIVersion()); 
        fluent.withEnv(instance.getEnv()); 
        fluent.withExposeDockerSocket(instance.getExposeDockerSocket()); 
        fluent.withForcePull(instance.getForcePull()); 
        fluent.withFrom(instance.getFrom()); 
        fluent.withPullSecret(instance.getPullSecret()); 
        fluent.withSecrets(instance.getSecrets()); 
        this.validationEnabled = validationEnabled; 
    }

    public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategy instance) {
        this(instance,true);
    }

    public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategy instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBuildAPIVersion(instance.getBuildAPIVersion()); 
        this.withEnv(instance.getEnv()); 
        this.withExposeDockerSocket(instance.getExposeDockerSocket()); 
        this.withForcePull(instance.getForcePull()); 
        this.withFrom(instance.getFrom()); 
        this.withPullSecret(instance.getPullSecret()); 
        this.withSecrets(instance.getSecrets()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.CustomBuildStrategy build() {
        CustomBuildStrategy buildable = new CustomBuildStrategy(fluent.getBuildAPIVersion(),fluent.getEnv(),fluent.getExposeDockerSocket(),fluent.getForcePull(),fluent.getFrom(),fluent.getPullSecret(),fluent.getSecrets());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomBuildStrategyBuilder that = (CustomBuildStrategyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
