package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubevirtPlatformStatusBuilder extends io.fabric8.openshift.api.model.KubevirtPlatformStatusFluentImpl<io.fabric8.openshift.api.model.KubevirtPlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.KubevirtPlatformStatus,io.fabric8.openshift.api.model.KubevirtPlatformStatusBuilder> {

    io.fabric8.openshift.api.model.KubevirtPlatformStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KubevirtPlatformStatusBuilder() {
        this(true);
    }

    public KubevirtPlatformStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new KubevirtPlatformStatus(), validationEnabled);
    }

    public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KubevirtPlatformStatus(), validationEnabled);
    }

    public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.KubevirtPlatformStatus instance) {
        this(fluent, instance, true);
    }

    public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.KubevirtPlatformStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        fluent.withIngressIP(instance.getIngressIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatus instance) {
        this(instance,true);
    }

    public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        this.withIngressIP(instance.getIngressIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.KubevirtPlatformStatus build() {
        KubevirtPlatformStatus buildable = new KubevirtPlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubevirtPlatformStatusBuilder that = (KubevirtPlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
