package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PlatformSpecBuilder extends io.fabric8.openshift.api.model.PlatformSpecFluentImpl<io.fabric8.openshift.api.model.PlatformSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.PlatformSpec,io.fabric8.openshift.api.model.PlatformSpecBuilder> {

    io.fabric8.openshift.api.model.PlatformSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PlatformSpecBuilder() {
        this(true);
    }

    public PlatformSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new PlatformSpec(), validationEnabled);
    }

    public PlatformSpecBuilder(io.fabric8.openshift.api.model.PlatformSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public PlatformSpecBuilder(io.fabric8.openshift.api.model.PlatformSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PlatformSpec(), validationEnabled);
    }

    public PlatformSpecBuilder(io.fabric8.openshift.api.model.PlatformSpecFluent<?> fluent,io.fabric8.openshift.api.model.PlatformSpec instance) {
        this(fluent, instance, true);
    }

    public PlatformSpecBuilder(io.fabric8.openshift.api.model.PlatformSpecFluent<?> fluent,io.fabric8.openshift.api.model.PlatformSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAws(instance.getAws()); 
        fluent.withAzure(instance.getAzure()); 
        fluent.withBaremetal(instance.getBaremetal()); 
        fluent.withEquinixMetal(instance.getEquinixMetal()); 
        fluent.withGcp(instance.getGcp()); 
        fluent.withIbmcloud(instance.getIbmcloud()); 
        fluent.withKubevirt(instance.getKubevirt()); 
        fluent.withOpenstack(instance.getOpenstack()); 
        fluent.withOvirt(instance.getOvirt()); 
        fluent.withType(instance.getType()); 
        fluent.withVsphere(instance.getVsphere()); 
        this.validationEnabled = validationEnabled; 
    }

    public PlatformSpecBuilder(io.fabric8.openshift.api.model.PlatformSpec instance) {
        this(instance,true);
    }

    public PlatformSpecBuilder(io.fabric8.openshift.api.model.PlatformSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAws(instance.getAws()); 
        this.withAzure(instance.getAzure()); 
        this.withBaremetal(instance.getBaremetal()); 
        this.withEquinixMetal(instance.getEquinixMetal()); 
        this.withGcp(instance.getGcp()); 
        this.withIbmcloud(instance.getIbmcloud()); 
        this.withKubevirt(instance.getKubevirt()); 
        this.withOpenstack(instance.getOpenstack()); 
        this.withOvirt(instance.getOvirt()); 
        this.withType(instance.getType()); 
        this.withVsphere(instance.getVsphere()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.PlatformSpec build() {
        PlatformSpec buildable = new PlatformSpec(fluent.getAws(),fluent.getAzure(),fluent.getBaremetal(),fluent.getEquinixMetal(),fluent.getGcp(),fluent.getIbmcloud(),fluent.getKubevirt(),fluent.getOpenstack(),fluent.getOvirt(),fluent.getType(),fluent.getVsphere());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PlatformSpecBuilder that = (PlatformSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
