package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProxyBuilder extends io.fabric8.openshift.api.model.ProxyFluentImpl<io.fabric8.openshift.api.model.ProxyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.Proxy,io.fabric8.openshift.api.model.ProxyBuilder> {

    io.fabric8.openshift.api.model.ProxyFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ProxyBuilder() {
        this(true);
    }

    public ProxyBuilder(java.lang.Boolean validationEnabled) {
        this(new Proxy(), validationEnabled);
    }

    public ProxyBuilder(io.fabric8.openshift.api.model.ProxyFluent<?> fluent) {
        this(fluent, true);
    }

    public ProxyBuilder(io.fabric8.openshift.api.model.ProxyFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Proxy(), validationEnabled);
    }

    public ProxyBuilder(io.fabric8.openshift.api.model.ProxyFluent<?> fluent,io.fabric8.openshift.api.model.Proxy instance) {
        this(fluent, instance, true);
    }

    public ProxyBuilder(io.fabric8.openshift.api.model.ProxyFluent<?> fluent,io.fabric8.openshift.api.model.Proxy instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ProxyBuilder(io.fabric8.openshift.api.model.Proxy instance) {
        this(instance,true);
    }

    public ProxyBuilder(io.fabric8.openshift.api.model.Proxy instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.Proxy build() {
        Proxy buildable = new Proxy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProxyBuilder that = (ProxyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
