package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RepositoryImportSpecBuilder extends io.fabric8.openshift.api.model.RepositoryImportSpecFluentImpl<io.fabric8.openshift.api.model.RepositoryImportSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.RepositoryImportSpec,io.fabric8.openshift.api.model.RepositoryImportSpecBuilder> {

    io.fabric8.openshift.api.model.RepositoryImportSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RepositoryImportSpecBuilder() {
        this(true);
    }

    public RepositoryImportSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new RepositoryImportSpec(), validationEnabled);
    }

    public RepositoryImportSpecBuilder(io.fabric8.openshift.api.model.RepositoryImportSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public RepositoryImportSpecBuilder(io.fabric8.openshift.api.model.RepositoryImportSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RepositoryImportSpec(), validationEnabled);
    }

    public RepositoryImportSpecBuilder(io.fabric8.openshift.api.model.RepositoryImportSpecFluent<?> fluent,io.fabric8.openshift.api.model.RepositoryImportSpec instance) {
        this(fluent, instance, true);
    }

    public RepositoryImportSpecBuilder(io.fabric8.openshift.api.model.RepositoryImportSpecFluent<?> fluent,io.fabric8.openshift.api.model.RepositoryImportSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFrom(instance.getFrom()); 
        fluent.withImportPolicy(instance.getImportPolicy()); 
        fluent.withIncludeManifest(instance.getIncludeManifest()); 
        fluent.withReferencePolicy(instance.getReferencePolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public RepositoryImportSpecBuilder(io.fabric8.openshift.api.model.RepositoryImportSpec instance) {
        this(instance,true);
    }

    public RepositoryImportSpecBuilder(io.fabric8.openshift.api.model.RepositoryImportSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFrom(instance.getFrom()); 
        this.withImportPolicy(instance.getImportPolicy()); 
        this.withIncludeManifest(instance.getIncludeManifest()); 
        this.withReferencePolicy(instance.getReferencePolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.RepositoryImportSpec build() {
        RepositoryImportSpec buildable = new RepositoryImportSpec(fluent.getFrom(),fluent.getImportPolicy(),fluent.getIncludeManifest(),fluent.getReferencePolicy());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RepositoryImportSpecBuilder that = (RepositoryImportSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
