package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RollingDeploymentStrategyParamsBuilder extends io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentImpl<io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.RollingDeploymentStrategyParams,io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsBuilder> {

    io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RollingDeploymentStrategyParamsBuilder() {
        this(true);
    }

    public RollingDeploymentStrategyParamsBuilder(java.lang.Boolean validationEnabled) {
        this(new RollingDeploymentStrategyParams(), validationEnabled);
    }

    public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<?> fluent) {
        this(fluent, true);
    }

    public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RollingDeploymentStrategyParams(), validationEnabled);
    }

    public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<?> fluent,io.fabric8.openshift.api.model.RollingDeploymentStrategyParams instance) {
        this(fluent, instance, true);
    }

    public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<?> fluent,io.fabric8.openshift.api.model.RollingDeploymentStrategyParams instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withIntervalSeconds(instance.getIntervalSeconds()); 
        fluent.withMaxSurge(instance.getMaxSurge()); 
        fluent.withMaxUnavailable(instance.getMaxUnavailable()); 
        fluent.withPost(instance.getPost()); 
        fluent.withPre(instance.getPre()); 
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        fluent.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParams instance) {
        this(instance,true);
    }

    public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParams instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withIntervalSeconds(instance.getIntervalSeconds()); 
        this.withMaxSurge(instance.getMaxSurge()); 
        this.withMaxUnavailable(instance.getMaxUnavailable()); 
        this.withPost(instance.getPost()); 
        this.withPre(instance.getPre()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.RollingDeploymentStrategyParams build() {
        RollingDeploymentStrategyParams buildable = new RollingDeploymentStrategyParams(fluent.getIntervalSeconds(),fluent.getMaxSurge(),fluent.getMaxUnavailable(),fluent.getPost(),fluent.getPre(),fluent.getTimeoutSeconds(),fluent.getUpdatePeriodSeconds());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RollingDeploymentStrategyParamsBuilder that = (RollingDeploymentStrategyParamsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
