package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TemplateInstanceBuilder extends io.fabric8.openshift.api.model.TemplateInstanceFluentImpl<io.fabric8.openshift.api.model.TemplateInstanceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.TemplateInstance,io.fabric8.openshift.api.model.TemplateInstanceBuilder> {

    io.fabric8.openshift.api.model.TemplateInstanceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TemplateInstanceBuilder() {
        this(true);
    }

    public TemplateInstanceBuilder(java.lang.Boolean validationEnabled) {
        this(new TemplateInstance(), validationEnabled);
    }

    public TemplateInstanceBuilder(io.fabric8.openshift.api.model.TemplateInstanceFluent<?> fluent) {
        this(fluent, true);
    }

    public TemplateInstanceBuilder(io.fabric8.openshift.api.model.TemplateInstanceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TemplateInstance(), validationEnabled);
    }

    public TemplateInstanceBuilder(io.fabric8.openshift.api.model.TemplateInstanceFluent<?> fluent,io.fabric8.openshift.api.model.TemplateInstance instance) {
        this(fluent, instance, true);
    }

    public TemplateInstanceBuilder(io.fabric8.openshift.api.model.TemplateInstanceFluent<?> fluent,io.fabric8.openshift.api.model.TemplateInstance instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public TemplateInstanceBuilder(io.fabric8.openshift.api.model.TemplateInstance instance) {
        this(instance,true);
    }

    public TemplateInstanceBuilder(io.fabric8.openshift.api.model.TemplateInstance instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.TemplateInstance build() {
        TemplateInstance buildable = new TemplateInstance(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TemplateInstanceBuilder that = (TemplateInstanceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
