package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class UserFluentImpl<A extends io.fabric8.openshift.api.model.UserFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.UserFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.String fullName;
    private java.util.List<java.lang.String> groups = new java.util.ArrayList<java.lang.String>();
    private java.util.List<java.lang.String> identities = new java.util.ArrayList<java.lang.String>();
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;

    public UserFluentImpl() {
    }

    public UserFluentImpl(io.fabric8.openshift.api.model.User instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withFullName(instance.getFullName()); 
        this.withGroups(instance.getGroups()); 
        this.withIdentities(instance.getIdentities()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getFullName() {
        return this.fullName;
    }

    public A withFullName(java.lang.String fullName) {
        this.fullName=fullName; return (A) this;
    }

    public java.lang.Boolean hasFullName() {
        return this.fullName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFullName instead.
     */
        public A withNewFullName(java.lang.String arg0) {
        return (A)withFullName(new String(arg0));
    }

    public A addToGroups(int index,java.lang.String item) {
        if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
        this.groups.add(index, item);
        return (A)this;
    }

    public A setToGroups(int index,java.lang.String item) {
        if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
        this.groups.set(index, item); return (A)this;
    }

    public A addToGroups(java.lang.String... items) {
        if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.groups.add(item);} return (A)this;
    }

    public A addAllToGroups(java.util.Collection<java.lang.String> items) {
        if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.groups.add(item);} return (A)this;
    }

    public A removeFromGroups(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public A removeAllFromGroups(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getGroups() {
        return this.groups;
    }

    public java.lang.String getGroup(int index) {
        return this.groups.get(index);
    }

    public java.lang.String getFirstGroup() {
        return this.groups.get(0);
    }

    public java.lang.String getLastGroup() {
        return this.groups.get(groups.size() - 1);
    }

    public java.lang.String getMatchingGroup(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: groups) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingGroup(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: groups) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGroups(java.util.List<java.lang.String> groups) {
        if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
        if (groups != null) {this.groups = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
    }

    public A withGroups(java.lang.String... groups) {
        if (this.groups != null) {this.groups.clear();}
        if (groups != null) {for (java.lang.String item :groups){ this.addToGroups(item);}} return (A) this;
    }

    public java.lang.Boolean hasGroups() {
        return groups != null && !groups.isEmpty();
    }

    public A addNewGroup(java.lang.String arg0) {
        return (A)addToGroups(new String(arg0));
    }

    public A addToIdentities(int index,java.lang.String item) {
        if (this.identities == null) {this.identities = new java.util.ArrayList<java.lang.String>();}
        this.identities.add(index, item);
        return (A)this;
    }

    public A setToIdentities(int index,java.lang.String item) {
        if (this.identities == null) {this.identities = new java.util.ArrayList<java.lang.String>();}
        this.identities.set(index, item); return (A)this;
    }

    public A addToIdentities(java.lang.String... items) {
        if (this.identities == null) {this.identities = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.identities.add(item);} return (A)this;
    }

    public A addAllToIdentities(java.util.Collection<java.lang.String> items) {
        if (this.identities == null) {this.identities = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.identities.add(item);} return (A)this;
    }

    public A removeFromIdentities(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.identities!= null){ this.identities.remove(item);}} return (A)this;
    }

    public A removeAllFromIdentities(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.identities!= null){ this.identities.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getIdentities() {
        return this.identities;
    }

    public java.lang.String getIdentity(int index) {
        return this.identities.get(index);
    }

    public java.lang.String getFirstIdentity() {
        return this.identities.get(0);
    }

    public java.lang.String getLastIdentity() {
        return this.identities.get(identities.size() - 1);
    }

    public java.lang.String getMatchingIdentity(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: identities) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingIdentity(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: identities) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIdentities(java.util.List<java.lang.String> identities) {
        if (this.identities != null) { _visitables.get("identities").removeAll(this.identities);}
        if (identities != null) {this.identities = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : identities){this.addToIdentities(item);}} else { this.identities = null;} return (A) this;
    }

    public A withIdentities(java.lang.String... identities) {
        if (this.identities != null) {this.identities.clear();}
        if (identities != null) {for (java.lang.String item :identities){ this.addToIdentities(item);}} return (A) this;
    }

    public java.lang.Boolean hasIdentities() {
        return identities != null && !identities.isEmpty();
    }

    public A addNewIdentity(java.lang.String arg0) {
        return (A)addToIdentities(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.UserFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.openshift.api.model.UserFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.UserFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.openshift.api.model.UserFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.UserFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.UserFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.UserFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserFluentImpl that = (UserFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (fullName != null ? !fullName.equals(that.fullName) :that.fullName != null) return false;
        if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
        if (identities != null ? !identities.equals(that.identities) :that.identities != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  fullName,  groups,  identities,  kind,  metadata,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.UserFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.UserFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) UserFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
