package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class UserIdentityMappingFluentImpl<A extends io.fabric8.openshift.api.model.UserIdentityMappingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.UserIdentityMappingFluent<A> {

    private java.lang.String apiVersion;
    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder identity;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder user;

    public UserIdentityMappingFluentImpl() {
    }

    public UserIdentityMappingFluentImpl(io.fabric8.openshift.api.model.UserIdentityMapping instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withIdentity(instance.getIdentity()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withUser(instance.getUser()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildIdentity instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectReference getIdentity() {
        return this.identity!=null?this.identity.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildIdentity() {
        return this.identity!=null?this.identity.build():null;
    }

    public A withIdentity(io.fabric8.kubernetes.api.model.ObjectReference identity) {
        _visitables.get("identity").remove(this.identity);
        if (identity!=null){ this.identity= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(identity); _visitables.get("identity").add(this.identity);} return (A) this;
    }

    public java.lang.Boolean hasIdentity() {
        return this.identity != null;
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.IdentityNested<A> withNewIdentity() {
        return new io.fabric8.openshift.api.model.UserIdentityMappingFluentImpl.IdentityNestedImpl();
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.IdentityNested<A> withNewIdentityLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.openshift.api.model.UserIdentityMappingFluentImpl.IdentityNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.IdentityNested<A> editIdentity() {
        return withNewIdentityLike(getIdentity());
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.IdentityNested<A> editOrNewIdentity() {
        return withNewIdentityLike(getIdentity() != null ? getIdentity(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.IdentityNested<A> editOrNewIdentityLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewIdentityLike(getIdentity() != null ? getIdentity(): item);
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.openshift.api.model.UserIdentityMappingFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.openshift.api.model.UserIdentityMappingFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildUser instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectReference getUser() {
        return this.user!=null?this.user.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildUser() {
        return this.user!=null?this.user.build():null;
    }

    public A withUser(io.fabric8.kubernetes.api.model.ObjectReference user) {
        _visitables.get("user").remove(this.user);
        if (user!=null){ this.user= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(user); _visitables.get("user").add(this.user);} return (A) this;
    }

    public java.lang.Boolean hasUser() {
        return this.user != null;
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.UserNested<A> withNewUser() {
        return new io.fabric8.openshift.api.model.UserIdentityMappingFluentImpl.UserNestedImpl();
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.UserNested<A> withNewUserLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.openshift.api.model.UserIdentityMappingFluentImpl.UserNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.UserNested<A> editUser() {
        return withNewUserLike(getUser());
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.UserNested<A> editOrNewUser() {
        return withNewUserLike(getUser() != null ? getUser(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.UserIdentityMappingFluent.UserNested<A> editOrNewUserLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewUserLike(getUser() != null ? getUser(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserIdentityMappingFluentImpl that = (UserIdentityMappingFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (identity != null ? !identity.equals(that.identity) :that.identity != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (user != null ? !user.equals(that.user) :that.user != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  identity,  kind,  metadata,  user,  super.hashCode());
    }

    public class IdentityNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.UserIdentityMappingFluent.IdentityNested<N>> implements io.fabric8.openshift.api.model.UserIdentityMappingFluent.IdentityNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            IdentityNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            IdentityNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) UserIdentityMappingFluentImpl.this.withIdentity(builder.build());
            }

            public N endIdentity() {
                return and();
            }
    }


    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.UserIdentityMappingFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.UserIdentityMappingFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) UserIdentityMappingFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class UserNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.UserIdentityMappingFluent.UserNested<N>> implements io.fabric8.openshift.api.model.UserIdentityMappingFluent.UserNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            UserNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            UserNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) UserIdentityMappingFluentImpl.this.withUser(builder.build());
            }

            public N endUser() {
                return and();
            }
    }


}
