package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildSpecBuilder extends io.fabric8.openshift.api.model.BuildSpecFluentImpl<io.fabric8.openshift.api.model.BuildSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.BuildSpec,io.fabric8.openshift.api.model.BuildSpecBuilder> {

    io.fabric8.openshift.api.model.BuildSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BuildSpecBuilder() {
        this(true);
    }

    public BuildSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new BuildSpec(), validationEnabled);
    }

    public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new BuildSpec(), validationEnabled);
    }

    public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpecFluent<?> fluent,io.fabric8.openshift.api.model.BuildSpec instance) {
        this(fluent, instance, true);
    }

    public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpecFluent<?> fluent,io.fabric8.openshift.api.model.BuildSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
        fluent.withMountTrustedCA(instance.getMountTrustedCA()); 
        fluent.withNodeSelector(instance.getNodeSelector()); 
        fluent.withOutput(instance.getOutput()); 
        fluent.withPostCommit(instance.getPostCommit()); 
        fluent.withResources(instance.getResources()); 
        fluent.withRevision(instance.getRevision()); 
        fluent.withServiceAccount(instance.getServiceAccount()); 
        fluent.withSource(instance.getSource()); 
        fluent.withStrategy(instance.getStrategy()); 
        fluent.withTriggeredBy(instance.getTriggeredBy()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpec instance) {
        this(instance,true);
    }

    public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
        this.withMountTrustedCA(instance.getMountTrustedCA()); 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withOutput(instance.getOutput()); 
        this.withPostCommit(instance.getPostCommit()); 
        this.withResources(instance.getResources()); 
        this.withRevision(instance.getRevision()); 
        this.withServiceAccount(instance.getServiceAccount()); 
        this.withSource(instance.getSource()); 
        this.withStrategy(instance.getStrategy()); 
        this.withTriggeredBy(instance.getTriggeredBy()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.BuildSpec build() {
        BuildSpec buildable = new BuildSpec(fluent.getCompletionDeadlineSeconds(),fluent.getMountTrustedCA(),fluent.getNodeSelector(),fluent.getOutput(),fluent.getPostCommit(),fluent.getResources(),fluent.getRevision(),fluent.getServiceAccount(),fluent.getSource(),fluent.getStrategy(),fluent.getTriggeredBy());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildSpecBuilder that = (BuildSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
