package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ComponentRouteSpecBuilder extends io.fabric8.openshift.api.model.ComponentRouteSpecFluentImpl<io.fabric8.openshift.api.model.ComponentRouteSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ComponentRouteSpec,io.fabric8.openshift.api.model.ComponentRouteSpecBuilder> {

    io.fabric8.openshift.api.model.ComponentRouteSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ComponentRouteSpecBuilder() {
        this(true);
    }

    public ComponentRouteSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new ComponentRouteSpec(), validationEnabled);
    }

    public ComponentRouteSpecBuilder(io.fabric8.openshift.api.model.ComponentRouteSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ComponentRouteSpecBuilder(io.fabric8.openshift.api.model.ComponentRouteSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ComponentRouteSpec(), validationEnabled);
    }

    public ComponentRouteSpecBuilder(io.fabric8.openshift.api.model.ComponentRouteSpecFluent<?> fluent,io.fabric8.openshift.api.model.ComponentRouteSpec instance) {
        this(fluent, instance, true);
    }

    public ComponentRouteSpecBuilder(io.fabric8.openshift.api.model.ComponentRouteSpecFluent<?> fluent,io.fabric8.openshift.api.model.ComponentRouteSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHostname(instance.getHostname()); 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public ComponentRouteSpecBuilder(io.fabric8.openshift.api.model.ComponentRouteSpec instance) {
        this(instance,true);
    }

    public ComponentRouteSpecBuilder(io.fabric8.openshift.api.model.ComponentRouteSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHostname(instance.getHostname()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ComponentRouteSpec build() {
        ComponentRouteSpec buildable = new ComponentRouteSpec(fluent.getHostname(),fluent.getName(),fluent.getNamespace(),fluent.getServingCertKeyPairSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ComponentRouteSpecBuilder that = (ComponentRouteSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
