package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ExternalIPConfigFluentImpl<A extends io.fabric8.openshift.api.model.ExternalIPConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ExternalIPConfigFluent<A> {

    private java.util.List<java.lang.String> autoAssignCIDRs = new java.util.ArrayList<java.lang.String>();
    private io.fabric8.openshift.api.model.ExternalIPPolicyBuilder policy;

    public ExternalIPConfigFluentImpl() {
    }

    public ExternalIPConfigFluentImpl(io.fabric8.openshift.api.model.ExternalIPConfig instance) {
        this.withAutoAssignCIDRs(instance.getAutoAssignCIDRs()); 
        this.withPolicy(instance.getPolicy()); 
    }

    public A addToAutoAssignCIDRs(int index,java.lang.String item) {
        if (this.autoAssignCIDRs == null) {this.autoAssignCIDRs = new java.util.ArrayList<java.lang.String>();}
        this.autoAssignCIDRs.add(index, item);
        return (A)this;
    }

    public A setToAutoAssignCIDRs(int index,java.lang.String item) {
        if (this.autoAssignCIDRs == null) {this.autoAssignCIDRs = new java.util.ArrayList<java.lang.String>();}
        this.autoAssignCIDRs.set(index, item); return (A)this;
    }

    public A addToAutoAssignCIDRs(java.lang.String... items) {
        if (this.autoAssignCIDRs == null) {this.autoAssignCIDRs = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.autoAssignCIDRs.add(item);} return (A)this;
    }

    public A addAllToAutoAssignCIDRs(java.util.Collection<java.lang.String> items) {
        if (this.autoAssignCIDRs == null) {this.autoAssignCIDRs = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.autoAssignCIDRs.add(item);} return (A)this;
    }

    public A removeFromAutoAssignCIDRs(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.autoAssignCIDRs!= null){ this.autoAssignCIDRs.remove(item);}} return (A)this;
    }

    public A removeAllFromAutoAssignCIDRs(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.autoAssignCIDRs!= null){ this.autoAssignCIDRs.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getAutoAssignCIDRs() {
        return this.autoAssignCIDRs;
    }

    public java.lang.String getAutoAssignCIDR(int index) {
        return this.autoAssignCIDRs.get(index);
    }

    public java.lang.String getFirstAutoAssignCIDR() {
        return this.autoAssignCIDRs.get(0);
    }

    public java.lang.String getLastAutoAssignCIDR() {
        return this.autoAssignCIDRs.get(autoAssignCIDRs.size() - 1);
    }

    public java.lang.String getMatchingAutoAssignCIDR(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: autoAssignCIDRs) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingAutoAssignCIDR(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: autoAssignCIDRs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAutoAssignCIDRs(java.util.List<java.lang.String> autoAssignCIDRs) {
        if (this.autoAssignCIDRs != null) { _visitables.get("autoAssignCIDRs").removeAll(this.autoAssignCIDRs);}
        if (autoAssignCIDRs != null) {this.autoAssignCIDRs = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : autoAssignCIDRs){this.addToAutoAssignCIDRs(item);}} else { this.autoAssignCIDRs = null;} return (A) this;
    }

    public A withAutoAssignCIDRs(java.lang.String... autoAssignCIDRs) {
        if (this.autoAssignCIDRs != null) {this.autoAssignCIDRs.clear();}
        if (autoAssignCIDRs != null) {for (java.lang.String item :autoAssignCIDRs){ this.addToAutoAssignCIDRs(item);}} return (A) this;
    }

    public java.lang.Boolean hasAutoAssignCIDRs() {
        return autoAssignCIDRs != null && !autoAssignCIDRs.isEmpty();
    }

    public A addNewAutoAssignCIDR(java.lang.String arg0) {
        return (A)addToAutoAssignCIDRs(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPolicy instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.ExternalIPPolicy getPolicy() {
        return this.policy!=null?this.policy.build():null;
    }

    public io.fabric8.openshift.api.model.ExternalIPPolicy buildPolicy() {
        return this.policy!=null?this.policy.build():null;
    }

    public A withPolicy(io.fabric8.openshift.api.model.ExternalIPPolicy policy) {
        _visitables.get("policy").remove(this.policy);
        if (policy!=null){ this.policy= new io.fabric8.openshift.api.model.ExternalIPPolicyBuilder(policy); _visitables.get("policy").add(this.policy);} return (A) this;
    }

    public java.lang.Boolean hasPolicy() {
        return this.policy != null;
    }

    public io.fabric8.openshift.api.model.ExternalIPConfigFluent.PolicyNested<A> withNewPolicy() {
        return new io.fabric8.openshift.api.model.ExternalIPConfigFluentImpl.PolicyNestedImpl();
    }

    public io.fabric8.openshift.api.model.ExternalIPConfigFluent.PolicyNested<A> withNewPolicyLike(io.fabric8.openshift.api.model.ExternalIPPolicy item) {
        return new io.fabric8.openshift.api.model.ExternalIPConfigFluentImpl.PolicyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ExternalIPConfigFluent.PolicyNested<A> editPolicy() {
        return withNewPolicyLike(getPolicy());
    }

    public io.fabric8.openshift.api.model.ExternalIPConfigFluent.PolicyNested<A> editOrNewPolicy() {
        return withNewPolicyLike(getPolicy() != null ? getPolicy(): new io.fabric8.openshift.api.model.ExternalIPPolicyBuilder().build());
    }

    public io.fabric8.openshift.api.model.ExternalIPConfigFluent.PolicyNested<A> editOrNewPolicyLike(io.fabric8.openshift.api.model.ExternalIPPolicy item) {
        return withNewPolicyLike(getPolicy() != null ? getPolicy(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExternalIPConfigFluentImpl that = (ExternalIPConfigFluentImpl) o;
        if (autoAssignCIDRs != null ? !autoAssignCIDRs.equals(that.autoAssignCIDRs) :that.autoAssignCIDRs != null) return false;
        if (policy != null ? !policy.equals(that.policy) :that.policy != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(autoAssignCIDRs,  policy,  super.hashCode());
    }

    public class PolicyNestedImpl<N> extends io.fabric8.openshift.api.model.ExternalIPPolicyFluentImpl<io.fabric8.openshift.api.model.ExternalIPConfigFluent.PolicyNested<N>> implements io.fabric8.openshift.api.model.ExternalIPConfigFluent.PolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ExternalIPPolicyBuilder builder;

            PolicyNestedImpl(io.fabric8.openshift.api.model.ExternalIPPolicy item) {
                this.builder = new io.fabric8.openshift.api.model.ExternalIPPolicyBuilder(this, item);
                        
            }

            PolicyNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.ExternalIPPolicyBuilder(this);
                        
            }

            public N and() {
                return (N) ExternalIPConfigFluentImpl.this.withPolicy(builder.build());
            }

            public N endPolicy() {
                return and();
            }
    }


}
