package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageStreamTagReferenceBuilder extends io.fabric8.openshift.api.model.ImageStreamTagReferenceFluentImpl<io.fabric8.openshift.api.model.ImageStreamTagReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamTagReference,io.fabric8.openshift.api.model.ImageStreamTagReferenceBuilder> {

    io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ImageStreamTagReferenceBuilder() {
        this(true);
    }

    public ImageStreamTagReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new ImageStreamTagReference(), validationEnabled);
    }

    public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ImageStreamTagReference(), validationEnabled);
    }

    public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTagReference instance) {
        this(fluent, instance, true);
    }

    public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTagReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReference instance) {
        this(instance,true);
    }

    public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ImageStreamTagReference build() {
        ImageStreamTagReference buildable = new ImageStreamTagReference(fluent.getName(),fluent.getNamespace());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageStreamTagReferenceBuilder that = (ImageStreamTagReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
