package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

public class OAuthClientFluentImpl<A extends io.fabric8.openshift.api.model.OAuthClientFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.OAuthClientFluent<A> {

    private java.lang.Integer accessTokenInactivityTimeoutSeconds;
    private java.lang.Integer accessTokenMaxAgeSeconds;
    private java.util.List<java.lang.String> additionalSecrets = new java.util.ArrayList<java.lang.String>();
    private java.lang.String apiVersion;
    private java.lang.String grantMethod;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.util.List<java.lang.String> redirectURIs = new java.util.ArrayList<java.lang.String>();
    private java.lang.Boolean respondWithChallenges;
    private java.util.List<io.fabric8.openshift.api.model.ScopeRestrictionBuilder> scopeRestrictions =  new java.util.ArrayList<io.fabric8.openshift.api.model.ScopeRestrictionBuilder>();
    private java.lang.String secret;

    public OAuthClientFluentImpl() {
    }

    public OAuthClientFluentImpl(io.fabric8.openshift.api.model.OAuthClient instance) {
        this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
        this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
        this.withAdditionalSecrets(instance.getAdditionalSecrets()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withGrantMethod(instance.getGrantMethod()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withRedirectURIs(instance.getRedirectURIs()); 
        this.withRespondWithChallenges(instance.getRespondWithChallenges()); 
        this.withScopeRestrictions(instance.getScopeRestrictions()); 
        this.withSecret(instance.getSecret()); 
    }

    public java.lang.Integer getAccessTokenInactivityTimeoutSeconds() {
        return this.accessTokenInactivityTimeoutSeconds;
    }

    public A withAccessTokenInactivityTimeoutSeconds(java.lang.Integer accessTokenInactivityTimeoutSeconds) {
        this.accessTokenInactivityTimeoutSeconds=accessTokenInactivityTimeoutSeconds; return (A) this;
    }

    public java.lang.Boolean hasAccessTokenInactivityTimeoutSeconds() {
        return this.accessTokenInactivityTimeoutSeconds != null;
    }

    public java.lang.Integer getAccessTokenMaxAgeSeconds() {
        return this.accessTokenMaxAgeSeconds;
    }

    public A withAccessTokenMaxAgeSeconds(java.lang.Integer accessTokenMaxAgeSeconds) {
        this.accessTokenMaxAgeSeconds=accessTokenMaxAgeSeconds; return (A) this;
    }

    public java.lang.Boolean hasAccessTokenMaxAgeSeconds() {
        return this.accessTokenMaxAgeSeconds != null;
    }

    public A addToAdditionalSecrets(int index,java.lang.String item) {
        if (this.additionalSecrets == null) {this.additionalSecrets = new java.util.ArrayList<java.lang.String>();}
        this.additionalSecrets.add(index, item);
        return (A)this;
    }

    public A setToAdditionalSecrets(int index,java.lang.String item) {
        if (this.additionalSecrets == null) {this.additionalSecrets = new java.util.ArrayList<java.lang.String>();}
        this.additionalSecrets.set(index, item); return (A)this;
    }

    public A addToAdditionalSecrets(java.lang.String... items) {
        if (this.additionalSecrets == null) {this.additionalSecrets = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.additionalSecrets.add(item);} return (A)this;
    }

    public A addAllToAdditionalSecrets(java.util.Collection<java.lang.String> items) {
        if (this.additionalSecrets == null) {this.additionalSecrets = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.additionalSecrets.add(item);} return (A)this;
    }

    public A removeFromAdditionalSecrets(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.additionalSecrets!= null){ this.additionalSecrets.remove(item);}} return (A)this;
    }

    public A removeAllFromAdditionalSecrets(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.additionalSecrets!= null){ this.additionalSecrets.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getAdditionalSecrets() {
        return this.additionalSecrets;
    }

    public java.lang.String getAdditionalSecret(int index) {
        return this.additionalSecrets.get(index);
    }

    public java.lang.String getFirstAdditionalSecret() {
        return this.additionalSecrets.get(0);
    }

    public java.lang.String getLastAdditionalSecret() {
        return this.additionalSecrets.get(additionalSecrets.size() - 1);
    }

    public java.lang.String getMatchingAdditionalSecret(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: additionalSecrets) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingAdditionalSecret(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: additionalSecrets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAdditionalSecrets(java.util.List<java.lang.String> additionalSecrets) {
        if (this.additionalSecrets != null) { _visitables.get("additionalSecrets").removeAll(this.additionalSecrets);}
        if (additionalSecrets != null) {this.additionalSecrets = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : additionalSecrets){this.addToAdditionalSecrets(item);}} else { this.additionalSecrets = null;} return (A) this;
    }

    public A withAdditionalSecrets(java.lang.String... additionalSecrets) {
        if (this.additionalSecrets != null) {this.additionalSecrets.clear();}
        if (additionalSecrets != null) {for (java.lang.String item :additionalSecrets){ this.addToAdditionalSecrets(item);}} return (A) this;
    }

    public java.lang.Boolean hasAdditionalSecrets() {
        return additionalSecrets != null && !additionalSecrets.isEmpty();
    }

    public A addNewAdditionalSecret(java.lang.String arg0) {
        return (A)addToAdditionalSecrets(new String(arg0));
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getGrantMethod() {
        return this.grantMethod;
    }

    public A withGrantMethod(java.lang.String grantMethod) {
        this.grantMethod=grantMethod; return (A) this;
    }

    public java.lang.Boolean hasGrantMethod() {
        return this.grantMethod != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGrantMethod instead.
     */
        public A withNewGrantMethod(java.lang.String arg0) {
        return (A)withGrantMethod(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.openshift.api.model.OAuthClientFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.openshift.api.model.OAuthClientFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToRedirectURIs(int index,java.lang.String item) {
        if (this.redirectURIs == null) {this.redirectURIs = new java.util.ArrayList<java.lang.String>();}
        this.redirectURIs.add(index, item);
        return (A)this;
    }

    public A setToRedirectURIs(int index,java.lang.String item) {
        if (this.redirectURIs == null) {this.redirectURIs = new java.util.ArrayList<java.lang.String>();}
        this.redirectURIs.set(index, item); return (A)this;
    }

    public A addToRedirectURIs(java.lang.String... items) {
        if (this.redirectURIs == null) {this.redirectURIs = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.redirectURIs.add(item);} return (A)this;
    }

    public A addAllToRedirectURIs(java.util.Collection<java.lang.String> items) {
        if (this.redirectURIs == null) {this.redirectURIs = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.redirectURIs.add(item);} return (A)this;
    }

    public A removeFromRedirectURIs(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.redirectURIs!= null){ this.redirectURIs.remove(item);}} return (A)this;
    }

    public A removeAllFromRedirectURIs(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.redirectURIs!= null){ this.redirectURIs.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getRedirectURIs() {
        return this.redirectURIs;
    }

    public java.lang.String getRedirectURI(int index) {
        return this.redirectURIs.get(index);
    }

    public java.lang.String getFirstRedirectURI() {
        return this.redirectURIs.get(0);
    }

    public java.lang.String getLastRedirectURI() {
        return this.redirectURIs.get(redirectURIs.size() - 1);
    }

    public java.lang.String getMatchingRedirectURI(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: redirectURIs) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingRedirectURI(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: redirectURIs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRedirectURIs(java.util.List<java.lang.String> redirectURIs) {
        if (this.redirectURIs != null) { _visitables.get("redirectURIs").removeAll(this.redirectURIs);}
        if (redirectURIs != null) {this.redirectURIs = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : redirectURIs){this.addToRedirectURIs(item);}} else { this.redirectURIs = null;} return (A) this;
    }

    public A withRedirectURIs(java.lang.String... redirectURIs) {
        if (this.redirectURIs != null) {this.redirectURIs.clear();}
        if (redirectURIs != null) {for (java.lang.String item :redirectURIs){ this.addToRedirectURIs(item);}} return (A) this;
    }

    public java.lang.Boolean hasRedirectURIs() {
        return redirectURIs != null && !redirectURIs.isEmpty();
    }

    public A addNewRedirectURI(java.lang.String arg0) {
        return (A)addToRedirectURIs(new String(arg0));
    }

    public java.lang.Boolean getRespondWithChallenges() {
        return this.respondWithChallenges;
    }

    public A withRespondWithChallenges(java.lang.Boolean respondWithChallenges) {
        this.respondWithChallenges=respondWithChallenges; return (A) this;
    }

    public java.lang.Boolean hasRespondWithChallenges() {
        return this.respondWithChallenges != null;
    }

    public A addToScopeRestrictions(int index,io.fabric8.openshift.api.model.ScopeRestriction item) {
        if (this.scopeRestrictions == null) {this.scopeRestrictions = new java.util.ArrayList<io.fabric8.openshift.api.model.ScopeRestrictionBuilder>();}
        io.fabric8.openshift.api.model.ScopeRestrictionBuilder builder = new io.fabric8.openshift.api.model.ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").add(index >= 0 ? index : _visitables.get("scopeRestrictions").size(), builder);this.scopeRestrictions.add(index >= 0 ? index : scopeRestrictions.size(), builder); return (A)this;
    }

    public A setToScopeRestrictions(int index,io.fabric8.openshift.api.model.ScopeRestriction item) {
        if (this.scopeRestrictions == null) {this.scopeRestrictions = new java.util.ArrayList<io.fabric8.openshift.api.model.ScopeRestrictionBuilder>();}
        io.fabric8.openshift.api.model.ScopeRestrictionBuilder builder = new io.fabric8.openshift.api.model.ScopeRestrictionBuilder(item);
        if (index < 0 || index >= _visitables.get("scopeRestrictions").size()) { _visitables.get("scopeRestrictions").add(builder); } else { _visitables.get("scopeRestrictions").set(index, builder);}
        if (index < 0 || index >= scopeRestrictions.size()) { scopeRestrictions.add(builder); } else { scopeRestrictions.set(index, builder);}
         return (A)this;
    }

    public A addToScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... items) {
        if (this.scopeRestrictions == null) {this.scopeRestrictions = new java.util.ArrayList<io.fabric8.openshift.api.model.ScopeRestrictionBuilder>();}
        for (io.fabric8.openshift.api.model.ScopeRestriction item : items) {io.fabric8.openshift.api.model.ScopeRestrictionBuilder builder = new io.fabric8.openshift.api.model.ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").add(builder);this.scopeRestrictions.add(builder);} return (A)this;
    }

    public A addAllToScopeRestrictions(java.util.Collection<io.fabric8.openshift.api.model.ScopeRestriction> items) {
        if (this.scopeRestrictions == null) {this.scopeRestrictions = new java.util.ArrayList<io.fabric8.openshift.api.model.ScopeRestrictionBuilder>();}
        for (io.fabric8.openshift.api.model.ScopeRestriction item : items) {io.fabric8.openshift.api.model.ScopeRestrictionBuilder builder = new io.fabric8.openshift.api.model.ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").add(builder);this.scopeRestrictions.add(builder);} return (A)this;
    }

    public A removeFromScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... items) {
        for (io.fabric8.openshift.api.model.ScopeRestriction item : items) {io.fabric8.openshift.api.model.ScopeRestrictionBuilder builder = new io.fabric8.openshift.api.model.ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").remove(builder);if (this.scopeRestrictions != null) {this.scopeRestrictions.remove(builder);}} return (A)this;
    }

    public A removeAllFromScopeRestrictions(java.util.Collection<io.fabric8.openshift.api.model.ScopeRestriction> items) {
        for (io.fabric8.openshift.api.model.ScopeRestriction item : items) {io.fabric8.openshift.api.model.ScopeRestrictionBuilder builder = new io.fabric8.openshift.api.model.ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").remove(builder);if (this.scopeRestrictions != null) {this.scopeRestrictions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromScopeRestrictions(java.util.function.Predicate<io.fabric8.openshift.api.model.ScopeRestrictionBuilder> predicate) {
        if (scopeRestrictions == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.ScopeRestrictionBuilder> each = scopeRestrictions.iterator();
        final List visitables = _visitables.get("scopeRestrictions");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.ScopeRestrictionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildScopeRestrictions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.ScopeRestriction> getScopeRestrictions() {
        return build(scopeRestrictions);
    }

    public java.util.List<io.fabric8.openshift.api.model.ScopeRestriction> buildScopeRestrictions() {
        return build(scopeRestrictions);
    }

    public io.fabric8.openshift.api.model.ScopeRestriction buildScopeRestriction(int index) {
        return this.scopeRestrictions.get(index).build();
    }

    public io.fabric8.openshift.api.model.ScopeRestriction buildFirstScopeRestriction() {
        return this.scopeRestrictions.get(0).build();
    }

    public io.fabric8.openshift.api.model.ScopeRestriction buildLastScopeRestriction() {
        return this.scopeRestrictions.get(scopeRestrictions.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.ScopeRestriction buildMatchingScopeRestriction(java.util.function.Predicate<io.fabric8.openshift.api.model.ScopeRestrictionBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ScopeRestrictionBuilder item: scopeRestrictions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingScopeRestriction(java.util.function.Predicate<io.fabric8.openshift.api.model.ScopeRestrictionBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ScopeRestrictionBuilder item: scopeRestrictions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withScopeRestrictions(java.util.List<io.fabric8.openshift.api.model.ScopeRestriction> scopeRestrictions) {
        if (this.scopeRestrictions != null) { _visitables.get("scopeRestrictions").removeAll(this.scopeRestrictions);}
        if (scopeRestrictions != null) {this.scopeRestrictions = new java.util.ArrayList<io.fabric8.openshift.api.model.ScopeRestrictionBuilder>(); for (io.fabric8.openshift.api.model.ScopeRestriction item : scopeRestrictions){this.addToScopeRestrictions(item);}} else { this.scopeRestrictions = null;} return (A) this;
    }

    public A withScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... scopeRestrictions) {
        if (this.scopeRestrictions != null) {this.scopeRestrictions.clear();}
        if (scopeRestrictions != null) {for (io.fabric8.openshift.api.model.ScopeRestriction item :scopeRestrictions){ this.addToScopeRestrictions(item);}} return (A) this;
    }

    public java.lang.Boolean hasScopeRestrictions() {
        return scopeRestrictions != null && !scopeRestrictions.isEmpty();
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestriction() {
        return new io.fabric8.openshift.api.model.OAuthClientFluentImpl.ScopeRestrictionsNestedImpl();
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestrictionLike(io.fabric8.openshift.api.model.ScopeRestriction item) {
        return new io.fabric8.openshift.api.model.OAuthClientFluentImpl.ScopeRestrictionsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> setNewScopeRestrictionLike(int index,io.fabric8.openshift.api.model.ScopeRestriction item) {
        return new io.fabric8.openshift.api.model.OAuthClientFluentImpl.ScopeRestrictionsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editScopeRestriction(int index) {
        if (scopeRestrictions.size() <= index) throw new RuntimeException("Can't edit scopeRestrictions. Index exceeds size.");
        return setNewScopeRestrictionLike(index, buildScopeRestriction(index));
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editFirstScopeRestriction() {
        if (scopeRestrictions.size() == 0) throw new RuntimeException("Can't edit first scopeRestrictions. The list is empty.");
        return setNewScopeRestrictionLike(0, buildScopeRestriction(0));
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editLastScopeRestriction() {
        int index = scopeRestrictions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last scopeRestrictions. The list is empty.");
        return setNewScopeRestrictionLike(index, buildScopeRestriction(index));
    }

    public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editMatchingScopeRestriction(java.util.function.Predicate<io.fabric8.openshift.api.model.ScopeRestrictionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<scopeRestrictions.size();i++) { 
        if (predicate.test(scopeRestrictions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching scopeRestrictions. No match found.");
        return setNewScopeRestrictionLike(index, buildScopeRestriction(index));
    }

    public java.lang.String getSecret() {
        return this.secret;
    }

    public A withSecret(java.lang.String secret) {
        this.secret=secret; return (A) this;
    }

    public java.lang.Boolean hasSecret() {
        return this.secret != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withSecret instead.
     */
        public A withNewSecret(java.lang.String arg0) {
        return (A)withSecret(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OAuthClientFluentImpl that = (OAuthClientFluentImpl) o;
        if (accessTokenInactivityTimeoutSeconds != null ? !accessTokenInactivityTimeoutSeconds.equals(that.accessTokenInactivityTimeoutSeconds) :that.accessTokenInactivityTimeoutSeconds != null) return false;
        if (accessTokenMaxAgeSeconds != null ? !accessTokenMaxAgeSeconds.equals(that.accessTokenMaxAgeSeconds) :that.accessTokenMaxAgeSeconds != null) return false;
        if (additionalSecrets != null ? !additionalSecrets.equals(that.additionalSecrets) :that.additionalSecrets != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (grantMethod != null ? !grantMethod.equals(that.grantMethod) :that.grantMethod != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (redirectURIs != null ? !redirectURIs.equals(that.redirectURIs) :that.redirectURIs != null) return false;
        if (respondWithChallenges != null ? !respondWithChallenges.equals(that.respondWithChallenges) :that.respondWithChallenges != null) return false;
        if (scopeRestrictions != null ? !scopeRestrictions.equals(that.scopeRestrictions) :that.scopeRestrictions != null) return false;
        if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(accessTokenInactivityTimeoutSeconds,  accessTokenMaxAgeSeconds,  additionalSecrets,  apiVersion,  grantMethod,  kind,  metadata,  redirectURIs,  respondWithChallenges,  scopeRestrictions,  secret,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) OAuthClientFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class ScopeRestrictionsNestedImpl<N> extends io.fabric8.openshift.api.model.ScopeRestrictionFluentImpl<io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ScopeRestrictionBuilder builder;
        private final int index;

            ScopeRestrictionsNestedImpl(int index,io.fabric8.openshift.api.model.ScopeRestriction item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.ScopeRestrictionBuilder(this, item);
                        
            }

            ScopeRestrictionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.ScopeRestrictionBuilder(this);
                        
            }

            public N and() {
                return (N) OAuthClientFluentImpl.this.setToScopeRestrictions(index,builder.build());
            }

            public N endScopeRestriction() {
                return and();
            }
    }


}
