package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OAuthSpecBuilder extends io.fabric8.openshift.api.model.OAuthSpecFluentImpl<io.fabric8.openshift.api.model.OAuthSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.OAuthSpec,io.fabric8.openshift.api.model.OAuthSpecBuilder> {

    io.fabric8.openshift.api.model.OAuthSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public OAuthSpecBuilder() {
        this(true);
    }

    public OAuthSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new OAuthSpec(), validationEnabled);
    }

    public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new OAuthSpec(), validationEnabled);
    }

    public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpecFluent<?> fluent,io.fabric8.openshift.api.model.OAuthSpec instance) {
        this(fluent, instance, true);
    }

    public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpecFluent<?> fluent,io.fabric8.openshift.api.model.OAuthSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withIdentityProviders(instance.getIdentityProviders()); 
        fluent.withTemplates(instance.getTemplates()); 
        fluent.withTokenConfig(instance.getTokenConfig()); 
        this.validationEnabled = validationEnabled; 
    }

    public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpec instance) {
        this(instance,true);
    }

    public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withIdentityProviders(instance.getIdentityProviders()); 
        this.withTemplates(instance.getTemplates()); 
        this.withTokenConfig(instance.getTokenConfig()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.OAuthSpec build() {
        OAuthSpec buildable = new OAuthSpec(fluent.getIdentityProviders(),fluent.getTemplates(),fluent.getTokenConfig());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OAuthSpecBuilder that = (OAuthSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
