package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PodSecurityPolicyReviewSpecFluentImpl<A extends io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent<A> {

    private java.util.List<java.lang.String> serviceAccountNames = new java.util.ArrayList<java.lang.String>();
    private io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder template;

    public PodSecurityPolicyReviewSpecFluentImpl() {
    }

    public PodSecurityPolicyReviewSpecFluentImpl(io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpec instance) {
        this.withServiceAccountNames(instance.getServiceAccountNames()); 
        this.withTemplate(instance.getTemplate()); 
    }

    public A addToServiceAccountNames(int index,java.lang.String item) {
        if (this.serviceAccountNames == null) {this.serviceAccountNames = new java.util.ArrayList<java.lang.String>();}
        this.serviceAccountNames.add(index, item);
        return (A)this;
    }

    public A setToServiceAccountNames(int index,java.lang.String item) {
        if (this.serviceAccountNames == null) {this.serviceAccountNames = new java.util.ArrayList<java.lang.String>();}
        this.serviceAccountNames.set(index, item); return (A)this;
    }

    public A addToServiceAccountNames(java.lang.String... items) {
        if (this.serviceAccountNames == null) {this.serviceAccountNames = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.serviceAccountNames.add(item);} return (A)this;
    }

    public A addAllToServiceAccountNames(java.util.Collection<java.lang.String> items) {
        if (this.serviceAccountNames == null) {this.serviceAccountNames = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.serviceAccountNames.add(item);} return (A)this;
    }

    public A removeFromServiceAccountNames(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.serviceAccountNames!= null){ this.serviceAccountNames.remove(item);}} return (A)this;
    }

    public A removeAllFromServiceAccountNames(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.serviceAccountNames!= null){ this.serviceAccountNames.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getServiceAccountNames() {
        return this.serviceAccountNames;
    }

    public java.lang.String getServiceAccountName(int index) {
        return this.serviceAccountNames.get(index);
    }

    public java.lang.String getFirstServiceAccountName() {
        return this.serviceAccountNames.get(0);
    }

    public java.lang.String getLastServiceAccountName() {
        return this.serviceAccountNames.get(serviceAccountNames.size() - 1);
    }

    public java.lang.String getMatchingServiceAccountName(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: serviceAccountNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingServiceAccountName(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: serviceAccountNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withServiceAccountNames(java.util.List<java.lang.String> serviceAccountNames) {
        if (this.serviceAccountNames != null) { _visitables.get("serviceAccountNames").removeAll(this.serviceAccountNames);}
        if (serviceAccountNames != null) {this.serviceAccountNames = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : serviceAccountNames){this.addToServiceAccountNames(item);}} else { this.serviceAccountNames = null;} return (A) this;
    }

    public A withServiceAccountNames(java.lang.String... serviceAccountNames) {
        if (this.serviceAccountNames != null) {this.serviceAccountNames.clear();}
        if (serviceAccountNames != null) {for (java.lang.String item :serviceAccountNames){ this.addToServiceAccountNames(item);}} return (A) this;
    }

    public java.lang.Boolean hasServiceAccountNames() {
        return serviceAccountNames != null && !serviceAccountNames.isEmpty();
    }

    public A addNewServiceAccountName(java.lang.String arg0) {
        return (A)addToServiceAccountNames(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.PodTemplateSpec getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.fabric8.kubernetes.api.model.PodTemplateSpec buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluentImpl.TemplateNestedImpl();
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
        return new io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder().build());
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodSecurityPolicyReviewSpecFluentImpl that = (PodSecurityPolicyReviewSpecFluentImpl) o;
        if (serviceAccountNames != null ? !serviceAccountNames.equals(that.serviceAccountNames) :that.serviceAccountNames != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(serviceAccountNames,  template,  super.hashCode());
    }

    public class TemplateNestedImpl<N> extends io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl<io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent.TemplateNested<N>> implements io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder builder;

            TemplateNestedImpl(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
                this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PodSecurityPolicyReviewSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


}
