package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PolicyRuleFluent<A extends io.fabric8.openshift.api.model.PolicyRuleFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToApiGroups(int index,java.lang.String item);
    public A setToApiGroups(int index,java.lang.String item);
    public A addToApiGroups(java.lang.String... items);
    public A addAllToApiGroups(java.util.Collection<java.lang.String> items);
    public A removeFromApiGroups(java.lang.String... items);
    public A removeAllFromApiGroups(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getApiGroups();
    public java.lang.String getApiGroup(int index);
    public java.lang.String getFirstApiGroup();
    public java.lang.String getLastApiGroup();
    public java.lang.String getMatchingApiGroup(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingApiGroup(java.util.function.Predicate<java.lang.String> predicate);
    public A withApiGroups(java.util.List<java.lang.String> apiGroups);
    public A withApiGroups(java.lang.String... apiGroups);
    public java.lang.Boolean hasApiGroups();
    public A addNewApiGroup(java.lang.String arg0);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAttributeRestrictions instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.HasMetadata getAttributeRestrictions();
    public io.fabric8.kubernetes.api.model.HasMetadata buildAttributeRestrictions();
    public A withAttributeRestrictions(io.fabric8.kubernetes.api.model.HasMetadata attributeRestrictions);
    public java.lang.Boolean hasAttributeRestrictions();
    public A withClusterVersionAttributeRestrictions(io.fabric8.openshift.api.model.ClusterVersion clusterVersionAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<A> withNewClusterVersionAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<A> withNewClusterVersionAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterVersion item);
    public A withDNSAttributeRestrictions(io.fabric8.openshift.api.model.DNS dNSAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.DNSAttributeRestrictionsNested<A> withNewDNSAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.DNSAttributeRestrictionsNested<A> withNewDNSAttributeRestrictionsLike(io.fabric8.openshift.api.model.DNS item);
    public A withImageStreamImportAttributeRestrictions(io.fabric8.openshift.api.model.ImageStreamImport imageStreamImportAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageStreamImport item);
    public A withProxyAttributeRestrictions(io.fabric8.openshift.api.model.Proxy proxyAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ProxyAttributeRestrictionsNested<A> withNewProxyAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ProxyAttributeRestrictionsNested<A> withNewProxyAttributeRestrictionsLike(io.fabric8.openshift.api.model.Proxy item);
    public A withProjectAttributeRestrictions(io.fabric8.openshift.api.model.Project projectAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictionsLike(io.fabric8.openshift.api.model.Project item);
    public A withClusterOperatorAttributeRestrictions(io.fabric8.openshift.api.model.ClusterOperator clusterOperatorAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterOperatorAttributeRestrictionsNested<A> withNewClusterOperatorAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterOperatorAttributeRestrictionsNested<A> withNewClusterOperatorAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterOperator item);
    public A withBuildConfigAttributeRestrictions(io.fabric8.openshift.api.model.BuildConfig buildConfigAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictionsLike(io.fabric8.openshift.api.model.BuildConfig item);
    public A withHelmChartRepositoryAttributeRestrictions(io.fabric8.openshift.api.model.HelmChartRepository helmChartRepositoryAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictionsLike(io.fabric8.openshift.api.model.HelmChartRepository item);
    public A withInfrastructureAttributeRestrictions(io.fabric8.openshift.api.model.Infrastructure infrastructureAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.InfrastructureAttributeRestrictionsNested<A> withNewInfrastructureAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.InfrastructureAttributeRestrictionsNested<A> withNewInfrastructureAttributeRestrictionsLike(io.fabric8.openshift.api.model.Infrastructure item);
    public A withSchedulerAttributeRestrictions(io.fabric8.openshift.api.model.Scheduler schedulerAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.SchedulerAttributeRestrictionsNested<A> withNewSchedulerAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.SchedulerAttributeRestrictionsNested<A> withNewSchedulerAttributeRestrictionsLike(io.fabric8.openshift.api.model.Scheduler item);
    public A withRangeAllocationAttributeRestrictions(io.fabric8.openshift.api.model.RangeAllocation rangeAllocationAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictionsLike(io.fabric8.openshift.api.model.RangeAllocation item);
    public A withRouteAttributeRestrictions(io.fabric8.openshift.api.model.Route routeAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictionsLike(io.fabric8.openshift.api.model.Route item);
    public A withClusterNetworkAttributeRestrictions(io.fabric8.openshift.api.model.ClusterNetwork clusterNetworkAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterNetwork item);
    public A withOAuthAuthorizeTokenAttributeRestrictions(io.fabric8.openshift.api.model.OAuthAuthorizeToken oAuthAuthorizeTokenAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictionsLike(io.fabric8.openshift.api.model.OAuthAuthorizeToken item);
    public A withUserOAuthAccessTokenAttributeRestrictions(io.fabric8.openshift.api.model.UserOAuthAccessToken userOAuthAccessTokenAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictionsLike(io.fabric8.openshift.api.model.UserOAuthAccessToken item);
    public A withIngressAttributeRestrictions(io.fabric8.openshift.api.model.Ingress ingressAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.IngressAttributeRestrictionsNested<A> withNewIngressAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.IngressAttributeRestrictionsNested<A> withNewIngressAttributeRestrictionsLike(io.fabric8.openshift.api.model.Ingress item);
    public A withOAuthAttributeRestrictions(io.fabric8.openshift.api.model.OAuth oAuthAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAttributeRestrictionsNested<A> withNewOAuthAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAttributeRestrictionsNested<A> withNewOAuthAttributeRestrictionsLike(io.fabric8.openshift.api.model.OAuth item);
    public A withOperatorHubAttributeRestrictions(io.fabric8.openshift.api.model.OperatorHub operatorHubAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OperatorHubAttributeRestrictionsNested<A> withNewOperatorHubAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OperatorHubAttributeRestrictionsNested<A> withNewOperatorHubAttributeRestrictionsLike(io.fabric8.openshift.api.model.OperatorHub item);
    public A withClusterRoleBindingAttributeRestrictions(io.fabric8.openshift.api.model.ClusterRoleBinding clusterRoleBindingAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterRoleBinding item);
    public A withClusterResourceQuotaAttributeRestrictions(io.fabric8.openshift.api.model.ClusterResourceQuota clusterResourceQuotaAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterResourceQuota item);
    public A withProjectRequestAttributeRestrictions(io.fabric8.openshift.api.model.ProjectRequest projectRequestAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictionsLike(io.fabric8.openshift.api.model.ProjectRequest item);
    public A withTemplateAttributeRestrictions(io.fabric8.openshift.api.model.Template templateAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictionsLike(io.fabric8.openshift.api.model.Template item);
    public A withOAuthClientAuthorizationAttributeRestrictions(io.fabric8.openshift.api.model.OAuthClientAuthorization oAuthClientAuthorizationAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictionsLike(io.fabric8.openshift.api.model.OAuthClientAuthorization item);
    public A withClusterRoleAttributeRestrictions(io.fabric8.openshift.api.model.ClusterRole clusterRoleAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterRole item);
    public A withAuthenticationAttributeRestrictions(io.fabric8.openshift.api.model.Authentication authenticationAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.AuthenticationAttributeRestrictionsNested<A> withNewAuthenticationAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.AuthenticationAttributeRestrictionsNested<A> withNewAuthenticationAttributeRestrictionsLike(io.fabric8.openshift.api.model.Authentication item);
    public A withImageTagAttributeRestrictions(io.fabric8.openshift.api.model.ImageTag imageTagAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageTag item);
    public A withDeploymentConfigAttributeRestrictions(io.fabric8.openshift.api.model.DeploymentConfig deploymentConfigAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictionsLike(io.fabric8.openshift.api.model.DeploymentConfig item);
    public A withOAuthAccessTokenAttributeRestrictions(io.fabric8.openshift.api.model.OAuthAccessToken oAuthAccessTokenAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictionsLike(io.fabric8.openshift.api.model.OAuthAccessToken item);
    public A withRoleBindingAttributeRestrictions(io.fabric8.openshift.api.model.RoleBinding roleBindingAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictionsLike(io.fabric8.openshift.api.model.RoleBinding item);
    public A withImageAttributeRestrictions(io.fabric8.openshift.api.model.Image imageAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictionsLike(io.fabric8.openshift.api.model.Image item);
    public A withAPIServerAttributeRestrictions(io.fabric8.openshift.api.model.APIServer aPIServerAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.APIServerAttributeRestrictionsNested<A> withNewAPIServerAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.APIServerAttributeRestrictionsNested<A> withNewAPIServerAttributeRestrictionsLike(io.fabric8.openshift.api.model.APIServer item);
    public A withPersistentVolumeClaimAttributeRestrictions(io.fabric8.kubernetes.api.model.PersistentVolumeClaim persistentVolumeClaimAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictionsLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
    public A withImageStreamMappingAttributeRestrictions(io.fabric8.openshift.api.model.ImageStreamMapping imageStreamMappingAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageStreamMapping item);
    public A withRoleAttributeRestrictions(io.fabric8.openshift.api.model.Role roleAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictionsLike(io.fabric8.openshift.api.model.Role item);
    public A withBrokerTemplateInstanceAttributeRestrictions(io.fabric8.openshift.api.model.BrokerTemplateInstance brokerTemplateInstanceAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictionsLike(io.fabric8.openshift.api.model.BrokerTemplateInstance item);
    public A withFeatureGateAttributeRestrictions(io.fabric8.openshift.api.model.FeatureGate featureGateAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.FeatureGateAttributeRestrictionsNested<A> withNewFeatureGateAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.FeatureGateAttributeRestrictionsNested<A> withNewFeatureGateAttributeRestrictionsLike(io.fabric8.openshift.api.model.FeatureGate item);
    public A withUserAttributeRestrictions(io.fabric8.openshift.api.model.User userAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictionsLike(io.fabric8.openshift.api.model.User item);
    public A withImageStreamImageAttributeRestrictions(io.fabric8.openshift.api.model.ImageStreamImage imageStreamImageAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageStreamImage item);
    public A withTemplateInstanceAttributeRestrictions(io.fabric8.openshift.api.model.TemplateInstance templateInstanceAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictionsLike(io.fabric8.openshift.api.model.TemplateInstance item);
    public A withBuildAttributeRestrictions(io.fabric8.openshift.api.model.Build buildAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictionsLike(io.fabric8.openshift.api.model.Build item);
    public A withRoleBindingRestrictionAttributeRestrictions(io.fabric8.openshift.api.model.RoleBindingRestriction roleBindingRestrictionAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictionsLike(io.fabric8.openshift.api.model.RoleBindingRestriction item);
    public A withImageStreamTagAttributeRestrictions(io.fabric8.openshift.api.model.ImageStreamTag imageStreamTagAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageStreamTag item);
    public A withGroupAttributeRestrictions(io.fabric8.openshift.api.model.Group groupAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictionsLike(io.fabric8.openshift.api.model.Group item);
    public A withImageSignatureAttributeRestrictions(io.fabric8.openshift.api.model.ImageSignature imageSignatureAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageSignature item);
    public A withHostSubnetAttributeRestrictions(io.fabric8.openshift.api.model.HostSubnet hostSubnetAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictionsLike(io.fabric8.openshift.api.model.HostSubnet item);
    public A withAppliedClusterResourceQuotaAttributeRestrictions(io.fabric8.openshift.api.model.AppliedClusterResourceQuota appliedClusterResourceQuotaAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictionsLike(io.fabric8.openshift.api.model.AppliedClusterResourceQuota item);
    public A withSecurityContextConstraintsAttributeRestrictions(io.fabric8.openshift.api.model.SecurityContextConstraints securityContextConstraintsAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictionsLike(io.fabric8.openshift.api.model.SecurityContextConstraints item);
    public A withConsoleAttributeRestrictions(io.fabric8.openshift.api.model.Console consoleAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ConsoleAttributeRestrictionsNested<A> withNewConsoleAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ConsoleAttributeRestrictionsNested<A> withNewConsoleAttributeRestrictionsLike(io.fabric8.openshift.api.model.Console item);
    public A withBuildRequestAttributeRestrictions(io.fabric8.openshift.api.model.BuildRequest buildRequestAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictionsLike(io.fabric8.openshift.api.model.BuildRequest item);
    public A withEgressNetworkPolicyAttributeRestrictions(io.fabric8.openshift.api.model.EgressNetworkPolicy egressNetworkPolicyAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictionsLike(io.fabric8.openshift.api.model.EgressNetworkPolicy item);
    public A withNetNamespaceAttributeRestrictions(io.fabric8.openshift.api.model.NetNamespace netNamespaceAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictionsLike(io.fabric8.openshift.api.model.NetNamespace item);
    public A withUserIdentityMappingAttributeRestrictions(io.fabric8.openshift.api.model.UserIdentityMapping userIdentityMappingAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictionsLike(io.fabric8.openshift.api.model.UserIdentityMapping item);
    public A withImageStreamAttributeRestrictions(io.fabric8.openshift.api.model.ImageStream imageStreamAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageStream item);
    public A withNetworkAttributeRestrictions(io.fabric8.openshift.api.model.Network networkAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.NetworkAttributeRestrictionsNested<A> withNewNetworkAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.NetworkAttributeRestrictionsNested<A> withNewNetworkAttributeRestrictionsLike(io.fabric8.openshift.api.model.Network item);
    public A withOAuthClientAttributeRestrictions(io.fabric8.openshift.api.model.OAuthClient oAuthClientAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictionsLike(io.fabric8.openshift.api.model.OAuthClient item);
    public A withIdentityAttributeRestrictions(io.fabric8.openshift.api.model.Identity identityAttributeRestrictions);
    public io.fabric8.openshift.api.model.PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictions();
    public io.fabric8.openshift.api.model.PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictionsLike(io.fabric8.openshift.api.model.Identity item);
    public A addToNonResourceURLs(int index,java.lang.String item);
    public A setToNonResourceURLs(int index,java.lang.String item);
    public A addToNonResourceURLs(java.lang.String... items);
    public A addAllToNonResourceURLs(java.util.Collection<java.lang.String> items);
    public A removeFromNonResourceURLs(java.lang.String... items);
    public A removeAllFromNonResourceURLs(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getNonResourceURLs();
    public java.lang.String getNonResourceURL(int index);
    public java.lang.String getFirstNonResourceURL();
    public java.lang.String getLastNonResourceURL();
    public java.lang.String getMatchingNonResourceURL(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingNonResourceURL(java.util.function.Predicate<java.lang.String> predicate);
    public A withNonResourceURLs(java.util.List<java.lang.String> nonResourceURLs);
    public A withNonResourceURLs(java.lang.String... nonResourceURLs);
    public java.lang.Boolean hasNonResourceURLs();
    public A addNewNonResourceURL(java.lang.String arg0);
    public A addToResourceNames(int index,java.lang.String item);
    public A setToResourceNames(int index,java.lang.String item);
    public A addToResourceNames(java.lang.String... items);
    public A addAllToResourceNames(java.util.Collection<java.lang.String> items);
    public A removeFromResourceNames(java.lang.String... items);
    public A removeAllFromResourceNames(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getResourceNames();
    public java.lang.String getResourceName(int index);
    public java.lang.String getFirstResourceName();
    public java.lang.String getLastResourceName();
    public java.lang.String getMatchingResourceName(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingResourceName(java.util.function.Predicate<java.lang.String> predicate);
    public A withResourceNames(java.util.List<java.lang.String> resourceNames);
    public A withResourceNames(java.lang.String... resourceNames);
    public java.lang.Boolean hasResourceNames();
    public A addNewResourceName(java.lang.String arg0);
    public A addToResources(int index,java.lang.String item);
    public A setToResources(int index,java.lang.String item);
    public A addToResources(java.lang.String... items);
    public A addAllToResources(java.util.Collection<java.lang.String> items);
    public A removeFromResources(java.lang.String... items);
    public A removeAllFromResources(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getResources();
    public java.lang.String getResource(int index);
    public java.lang.String getFirstResource();
    public java.lang.String getLastResource();
    public java.lang.String getMatchingResource(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingResource(java.util.function.Predicate<java.lang.String> predicate);
    public A withResources(java.util.List<java.lang.String> resources);
    public A withResources(java.lang.String... resources);
    public java.lang.Boolean hasResources();
    public A addNewResource(java.lang.String arg0);
    public A addToVerbs(int index,java.lang.String item);
    public A setToVerbs(int index,java.lang.String item);
    public A addToVerbs(java.lang.String... items);
    public A addAllToVerbs(java.util.Collection<java.lang.String> items);
    public A removeFromVerbs(java.lang.String... items);
    public A removeAllFromVerbs(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getVerbs();
    public java.lang.String getVerb(int index);
    public java.lang.String getFirstVerb();
    public java.lang.String getLastVerb();
    public java.lang.String getMatchingVerb(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingVerb(java.util.function.Predicate<java.lang.String> predicate);
    public A withVerbs(java.util.List<java.lang.String> verbs);
    public A withVerbs(java.lang.String... verbs);
    public java.lang.Boolean hasVerbs();
    public A addNewVerb(java.lang.String arg0);
    public interface ClusterVersionAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ClusterVersionFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<N>> {

            public N and();
            public N endClusterVersionAttributeRestrictions();    }


    public interface DNSAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.DNSFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.DNSAttributeRestrictionsNested<N>> {

            public N and();
            public N endDNSAttributeRestrictions();    }


    public interface ImageStreamImportAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ImageStreamImportFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>> {

            public N and();
            public N endImageStreamImportAttributeRestrictions();    }


    public interface ProxyAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ProxyFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ProxyAttributeRestrictionsNested<N>> {

            public N and();
            public N endProxyAttributeRestrictions();    }


    public interface ProjectAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ProjectFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>> {

            public N and();
            public N endProjectAttributeRestrictions();    }


    public interface ClusterOperatorAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ClusterOperatorFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterOperatorAttributeRestrictionsNested<N>> {

            public N and();
            public N endClusterOperatorAttributeRestrictions();    }


    public interface BuildConfigAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.BuildConfigFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>> {

            public N and();
            public N endBuildConfigAttributeRestrictions();    }


    public interface HelmChartRepositoryAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.HelmChartRepositoryFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<N>> {

            public N and();
            public N endHelmChartRepositoryAttributeRestrictions();    }


    public interface InfrastructureAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.InfrastructureFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.InfrastructureAttributeRestrictionsNested<N>> {

            public N and();
            public N endInfrastructureAttributeRestrictions();    }


    public interface SchedulerAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.SchedulerFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.SchedulerAttributeRestrictionsNested<N>> {

            public N and();
            public N endSchedulerAttributeRestrictions();    }


    public interface RangeAllocationAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.RangeAllocationFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<N>> {

            public N and();
            public N endRangeAllocationAttributeRestrictions();    }


    public interface RouteAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.RouteFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.RouteAttributeRestrictionsNested<N>> {

            public N and();
            public N endRouteAttributeRestrictions();    }


    public interface ClusterNetworkAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ClusterNetworkFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<N>> {

            public N and();
            public N endClusterNetworkAttributeRestrictions();    }


    public interface OAuthAuthorizeTokenAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>> {

            public N and();
            public N endOAuthAuthorizeTokenAttributeRestrictions();    }


    public interface UserOAuthAccessTokenAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.UserOAuthAccessTokenFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<N>> {

            public N and();
            public N endUserOAuthAccessTokenAttributeRestrictions();    }


    public interface IngressAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.IngressFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.IngressAttributeRestrictionsNested<N>> {

            public N and();
            public N endIngressAttributeRestrictions();    }


    public interface OAuthAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.OAuthFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAttributeRestrictionsNested<N>> {

            public N and();
            public N endOAuthAttributeRestrictions();    }


    public interface OperatorHubAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.OperatorHubFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.OperatorHubAttributeRestrictionsNested<N>> {

            public N and();
            public N endOperatorHubAttributeRestrictions();    }


    public interface ClusterRoleBindingAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ClusterRoleBindingFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>> {

            public N and();
            public N endClusterRoleBindingAttributeRestrictions();    }


    public interface ClusterResourceQuotaAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ClusterResourceQuotaFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<N>> {

            public N and();
            public N endClusterResourceQuotaAttributeRestrictions();    }


    public interface ProjectRequestAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ProjectRequestFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>> {

            public N and();
            public N endProjectRequestAttributeRestrictions();    }


    public interface TemplateAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.TemplateFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>> {

            public N and();
            public N endTemplateAttributeRestrictions();    }


    public interface OAuthClientAuthorizationAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>> {

            public N and();
            public N endOAuthClientAuthorizationAttributeRestrictions();    }


    public interface ClusterRoleAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ClusterRoleFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>> {

            public N and();
            public N endClusterRoleAttributeRestrictions();    }


    public interface AuthenticationAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.AuthenticationFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.AuthenticationAttributeRestrictionsNested<N>> {

            public N and();
            public N endAuthenticationAttributeRestrictions();    }


    public interface ImageTagAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ImageTagFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ImageTagAttributeRestrictionsNested<N>> {

            public N and();
            public N endImageTagAttributeRestrictions();    }


    public interface DeploymentConfigAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.DeploymentConfigFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>> {

            public N and();
            public N endDeploymentConfigAttributeRestrictions();    }


    public interface OAuthAccessTokenAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.OAuthAccessTokenFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>> {

            public N and();
            public N endOAuthAccessTokenAttributeRestrictions();    }


    public interface RoleBindingAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.RoleBindingFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>> {

            public N and();
            public N endRoleBindingAttributeRestrictions();    }


    public interface ImageAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ImageFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ImageAttributeRestrictionsNested<N>> {

            public N and();
            public N endImageAttributeRestrictions();    }


    public interface APIServerAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.APIServerFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.APIServerAttributeRestrictionsNested<N>> {

            public N and();
            public N endAPIServerAttributeRestrictions();    }


    public interface PersistentVolumeClaimAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>> {

            public N and();
            public N endPersistentVolumeClaimAttributeRestrictions();    }


    public interface ImageStreamMappingAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ImageStreamMappingFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<N>> {

            public N and();
            public N endImageStreamMappingAttributeRestrictions();    }


    public interface RoleAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.RoleFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.RoleAttributeRestrictionsNested<N>> {

            public N and();
            public N endRoleAttributeRestrictions();    }


    public interface BrokerTemplateInstanceAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.BrokerTemplateInstanceFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<N>> {

            public N and();
            public N endBrokerTemplateInstanceAttributeRestrictions();    }


    public interface FeatureGateAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.FeatureGateFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.FeatureGateAttributeRestrictionsNested<N>> {

            public N and();
            public N endFeatureGateAttributeRestrictions();    }


    public interface UserAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.UserFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.UserAttributeRestrictionsNested<N>> {

            public N and();
            public N endUserAttributeRestrictions();    }


    public interface ImageStreamImageAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ImageStreamImageFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<N>> {

            public N and();
            public N endImageStreamImageAttributeRestrictions();    }


    public interface TemplateInstanceAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.TemplateInstanceFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<N>> {

            public N and();
            public N endTemplateInstanceAttributeRestrictions();    }


    public interface BuildAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.BuildFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.BuildAttributeRestrictionsNested<N>> {

            public N and();
            public N endBuildAttributeRestrictions();    }


    public interface RoleBindingRestrictionAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.RoleBindingRestrictionFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>> {

            public N and();
            public N endRoleBindingRestrictionAttributeRestrictions();    }


    public interface ImageStreamTagAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ImageStreamTagFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>> {

            public N and();
            public N endImageStreamTagAttributeRestrictions();    }


    public interface GroupAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.GroupFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.GroupAttributeRestrictionsNested<N>> {

            public N and();
            public N endGroupAttributeRestrictions();    }


    public interface ImageSignatureAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ImageSignatureFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>> {

            public N and();
            public N endImageSignatureAttributeRestrictions();    }


    public interface HostSubnetAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.HostSubnetFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<N>> {

            public N and();
            public N endHostSubnetAttributeRestrictions();    }


    public interface AppliedClusterResourceQuotaAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.AppliedClusterResourceQuotaFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>> {

            public N and();
            public N endAppliedClusterResourceQuotaAttributeRestrictions();    }


    public interface SecurityContextConstraintsAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.SecurityContextConstraintsFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>> {

            public N and();
            public N endSecurityContextConstraintsAttributeRestrictions();    }


    public interface ConsoleAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ConsoleFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ConsoleAttributeRestrictionsNested<N>> {

            public N and();
            public N endConsoleAttributeRestrictions();    }


    public interface BuildRequestAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.BuildRequestFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>> {

            public N and();
            public N endBuildRequestAttributeRestrictions();    }


    public interface EgressNetworkPolicyAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.EgressNetworkPolicyFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<N>> {

            public N and();
            public N endEgressNetworkPolicyAttributeRestrictions();    }


    public interface NetNamespaceAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.NetNamespaceFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>> {

            public N and();
            public N endNetNamespaceAttributeRestrictions();    }


    public interface UserIdentityMappingAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.UserIdentityMappingFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<N>> {

            public N and();
            public N endUserIdentityMappingAttributeRestrictions();    }


    public interface ImageStreamAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ImageStreamFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>> {

            public N and();
            public N endImageStreamAttributeRestrictions();    }


    public interface NetworkAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.NetworkFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.NetworkAttributeRestrictionsNested<N>> {

            public N and();
            public N endNetworkAttributeRestrictions();    }


    public interface OAuthClientAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.OAuthClientFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>> {

            public N and();
            public N endOAuthClientAttributeRestrictions();    }


    public interface IdentityAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.IdentityFluent<io.fabric8.openshift.api.model.PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>> {

            public N and();
            public N endIdentityAttributeRestrictions();    }


}
