package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteIngressBuilder extends io.fabric8.openshift.api.model.RouteIngressFluentImpl<io.fabric8.openshift.api.model.RouteIngressBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.RouteIngress,io.fabric8.openshift.api.model.RouteIngressBuilder> {

    io.fabric8.openshift.api.model.RouteIngressFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RouteIngressBuilder() {
        this(true);
    }

    public RouteIngressBuilder(java.lang.Boolean validationEnabled) {
        this(new RouteIngress(), validationEnabled);
    }

    public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngressFluent<?> fluent) {
        this(fluent, true);
    }

    public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngressFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RouteIngress(), validationEnabled);
    }

    public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngressFluent<?> fluent,io.fabric8.openshift.api.model.RouteIngress instance) {
        this(fluent, instance, true);
    }

    public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngressFluent<?> fluent,io.fabric8.openshift.api.model.RouteIngress instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withHost(instance.getHost()); 
        fluent.withRouterCanonicalHostname(instance.getRouterCanonicalHostname()); 
        fluent.withRouterName(instance.getRouterName()); 
        fluent.withWildcardPolicy(instance.getWildcardPolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngress instance) {
        this(instance,true);
    }

    public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngress instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withHost(instance.getHost()); 
        this.withRouterCanonicalHostname(instance.getRouterCanonicalHostname()); 
        this.withRouterName(instance.getRouterName()); 
        this.withWildcardPolicy(instance.getWildcardPolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.RouteIngress build() {
        RouteIngress buildable = new RouteIngress(fluent.getConditions(),fluent.getHost(),fluent.getRouterCanonicalHostname(),fluent.getRouterName(),fluent.getWildcardPolicy());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RouteIngressBuilder that = (RouteIngressBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
