package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.lang.Boolean;

public class RoutePortFluentImpl<A extends io.fabric8.openshift.api.model.RoutePortFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.RoutePortFluent<A> {

    private io.fabric8.kubernetes.api.model.IntOrStringBuilder targetPort;

    public RoutePortFluentImpl() {
    }

    public RoutePortFluentImpl(io.fabric8.openshift.api.model.RoutePort instance) {
        this.withTargetPort(instance.getTargetPort()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTargetPort instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.IntOrString getTargetPort() {
        return this.targetPort!=null?this.targetPort.build():null;
    }

    public io.fabric8.kubernetes.api.model.IntOrString buildTargetPort() {
        return this.targetPort!=null?this.targetPort.build():null;
    }

    public A withTargetPort(io.fabric8.kubernetes.api.model.IntOrString targetPort) {
        _visitables.get("targetPort").remove(this.targetPort);
        if (targetPort!=null){ this.targetPort= new io.fabric8.kubernetes.api.model.IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} return (A) this;
    }

    public java.lang.Boolean hasTargetPort() {
        return this.targetPort != null;
    }

    public A withNewTargetPort(java.lang.Integer intVal) {
        return (A)withTargetPort(new IntOrString(intVal));
    }

    public A withNewTargetPort(java.lang.String strVal) {
        return (A)withTargetPort(new IntOrString(strVal));
    }

    public io.fabric8.openshift.api.model.RoutePortFluent.TargetPortNested<A> withNewTargetPort() {
        return new io.fabric8.openshift.api.model.RoutePortFluentImpl.TargetPortNestedImpl();
    }

    public io.fabric8.openshift.api.model.RoutePortFluent.TargetPortNested<A> withNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return new io.fabric8.openshift.api.model.RoutePortFluentImpl.TargetPortNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.RoutePortFluent.TargetPortNested<A> editTargetPort() {
        return withNewTargetPortLike(getTargetPort());
    }

    public io.fabric8.openshift.api.model.RoutePortFluent.TargetPortNested<A> editOrNewTargetPort() {
        return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
    }

    public io.fabric8.openshift.api.model.RoutePortFluent.TargetPortNested<A> editOrNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RoutePortFluentImpl that = (RoutePortFluentImpl) o;
        if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(targetPort,  super.hashCode());
    }

    public class TargetPortNestedImpl<N> extends io.fabric8.kubernetes.api.model.IntOrStringFluentImpl<io.fabric8.openshift.api.model.RoutePortFluent.TargetPortNested<N>> implements io.fabric8.openshift.api.model.RoutePortFluent.TargetPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;

            TargetPortNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
                        
            }

            TargetPortNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
                        
            }

            public N and() {
                return (N) RoutePortFluentImpl.this.withTargetPort(builder.build());
            }

            public N endTargetPort() {
                return and();
            }
    }


}
