package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AzurePlatformStatusBuilder extends io.fabric8.openshift.api.model.AzurePlatformStatusFluentImpl<io.fabric8.openshift.api.model.AzurePlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.AzurePlatformStatus,io.fabric8.openshift.api.model.AzurePlatformStatusBuilder>{
  public AzurePlatformStatusBuilder() {
    this(false);
  }
  public AzurePlatformStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new AzurePlatformStatus(), validationEnabled);
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AzurePlatformStatus(), validationEnabled);
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.AzurePlatformStatus instance) {
    this(fluent, instance, false);
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.AzurePlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCloudName(instance.getCloudName()); 
    fluent.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
    fluent.withResourceGroupName(instance.getResourceGroupName()); 
    this.validationEnabled = validationEnabled; 
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatus instance) {
    this(instance,false);
  }
  public AzurePlatformStatusBuilder(io.fabric8.openshift.api.model.AzurePlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCloudName(instance.getCloudName()); 
    this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
    this.withResourceGroupName(instance.getResourceGroupName()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AzurePlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.AzurePlatformStatus build() {
    AzurePlatformStatus buildable = new AzurePlatformStatus(fluent.getCloudName(),fluent.getNetworkResourceGroupName(),fluent.getResourceGroupName());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzurePlatformStatusBuilder that = (AzurePlatformStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}