/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.APIServerNamedServingCert;
import io.fabric8.openshift.api.model.APIServerNamedServingCertFluent;
import io.fabric8.openshift.api.model.SecretNameReference;
import io.fabric8.openshift.api.model.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.SecretNameReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class APIServerNamedServingCertFluentImpl<A extends APIServerNamedServingCertFluent<A>>
extends BaseFluent<A>
implements APIServerNamedServingCertFluent<A> {
    private List<String> names = new ArrayList<String>();
    private SecretNameReferenceBuilder servingCertificate;

    public APIServerNamedServingCertFluentImpl() {
    }

    public APIServerNamedServingCertFluentImpl(APIServerNamedServingCert instance) {
        this.withNames(instance.getNames());
        this.withServingCertificate(instance.getServingCertificate());
    }

    @Override
    public A addToNames(Integer index, String item) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNames(Integer index, String item) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNames(String ... items) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNames(Collection<String> items) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNames(String ... items) {
        for (String item : items) {
            if (this.names == null) continue;
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNames(Collection<String> items) {
        for (String item : items) {
            if (this.names == null) continue;
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getName(Integer index) {
        return this.names.get(index);
    }

    @Override
    public String getFirstName() {
        return this.names.get(0);
    }

    @Override
    public String getLastName() {
        return this.names.get(this.names.size() - 1);
    }

    @Override
    public String getMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNames(List<String> names) {
        if (names != null) {
            this.names = new ArrayList<String>();
            for (String item : names) {
                this.addToNames(item);
            }
        } else {
            this.names = null;
        }
        return (A)this;
    }

    @Override
    public A withNames(String ... names) {
        if (this.names != null) {
            this.names.clear();
        }
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNames() {
        return this.names != null && !this.names.isEmpty();
    }

    @Override
    public A addNewName(String arg0) {
        return this.addToNames(new String(arg0));
    }

    @Override
    @Deprecated
    public SecretNameReference getServingCertificate() {
        return this.servingCertificate != null ? this.servingCertificate.build() : null;
    }

    @Override
    public SecretNameReference buildServingCertificate() {
        return this.servingCertificate != null ? this.servingCertificate.build() : null;
    }

    @Override
    public A withServingCertificate(SecretNameReference servingCertificate) {
        this._visitables.get((Object)"servingCertificate").remove(this.servingCertificate);
        if (servingCertificate != null) {
            this.servingCertificate = new SecretNameReferenceBuilder(servingCertificate);
            this._visitables.get((Object)"servingCertificate").add(this.servingCertificate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasServingCertificate() {
        return this.servingCertificate != null;
    }

    @Override
    public A withNewServingCertificate(String name) {
        return this.withServingCertificate(new SecretNameReference(name));
    }

    @Override
    public APIServerNamedServingCertFluent.ServingCertificateNested<A> withNewServingCertificate() {
        return new ServingCertificateNestedImpl();
    }

    @Override
    public APIServerNamedServingCertFluent.ServingCertificateNested<A> withNewServingCertificateLike(SecretNameReference item) {
        return new ServingCertificateNestedImpl(item);
    }

    @Override
    public APIServerNamedServingCertFluent.ServingCertificateNested<A> editServingCertificate() {
        return this.withNewServingCertificateLike(this.getServingCertificate());
    }

    @Override
    public APIServerNamedServingCertFluent.ServingCertificateNested<A> editOrNewServingCertificate() {
        return this.withNewServingCertificateLike(this.getServingCertificate() != null ? this.getServingCertificate() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public APIServerNamedServingCertFluent.ServingCertificateNested<A> editOrNewServingCertificateLike(SecretNameReference item) {
        return this.withNewServingCertificateLike(this.getServingCertificate() != null ? this.getServingCertificate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIServerNamedServingCertFluentImpl that = (APIServerNamedServingCertFluentImpl)o;
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        return !(this.servingCertificate != null ? !this.servingCertificate.equals(that.servingCertificate) : that.servingCertificate != null);
    }

    public int hashCode() {
        return Objects.hash(this.names, this.servingCertificate, super.hashCode());
    }

    public class ServingCertificateNestedImpl<N>
    extends SecretNameReferenceFluentImpl<APIServerNamedServingCertFluent.ServingCertificateNested<N>>
    implements APIServerNamedServingCertFluent.ServingCertificateNested<N>,
    Nested<N> {
        SecretNameReferenceBuilder builder;

        ServingCertificateNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        ServingCertificateNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIServerNamedServingCertFluentImpl.this.withServingCertificate(this.builder.build());
        }

        @Override
        public N endServingCertificate() {
            return this.and();
        }
    }
}

