package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AWSPlatformStatusBuilder extends io.fabric8.openshift.api.model.AWSPlatformStatusFluentImpl<io.fabric8.openshift.api.model.AWSPlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.AWSPlatformStatus,io.fabric8.openshift.api.model.AWSPlatformStatusBuilder>{
  public AWSPlatformStatusBuilder() {
    this(false);
  }
  public AWSPlatformStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new AWSPlatformStatus(), validationEnabled);
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AWSPlatformStatus(), validationEnabled);
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.AWSPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.AWSPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRegion(instance.getRegion()); 
    fluent.withResourceTags(instance.getResourceTags()); 
    fluent.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.validationEnabled = validationEnabled; 
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatus instance) {
    this(instance,false);
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRegion(instance.getRegion()); 
    this.withResourceTags(instance.getResourceTags()); 
    this.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AWSPlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.AWSPlatformStatus build() {
    AWSPlatformStatus buildable = new AWSPlatformStatus(fluent.getRegion(),fluent.getResourceTags(),fluent.getServiceEndpoints());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSPlatformStatusBuilder that = (AWSPlatformStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}