package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AuthenticationBuilder extends io.fabric8.openshift.api.model.AuthenticationFluentImpl<io.fabric8.openshift.api.model.AuthenticationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.Authentication,io.fabric8.openshift.api.model.AuthenticationBuilder>{
  public AuthenticationBuilder() {
    this(false);
  }
  public AuthenticationBuilder(java.lang.Boolean validationEnabled) {
    this(new Authentication(), validationEnabled);
  }
  public AuthenticationBuilder(io.fabric8.openshift.api.model.AuthenticationFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthenticationBuilder(io.fabric8.openshift.api.model.AuthenticationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Authentication(), validationEnabled);
  }
  public AuthenticationBuilder(io.fabric8.openshift.api.model.AuthenticationFluent<?> fluent,io.fabric8.openshift.api.model.Authentication instance) {
    this(fluent, instance, false);
  }
  public AuthenticationBuilder(io.fabric8.openshift.api.model.AuthenticationFluent<?> fluent,io.fabric8.openshift.api.model.Authentication instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public AuthenticationBuilder(io.fabric8.openshift.api.model.Authentication instance) {
    this(instance,false);
  }
  public AuthenticationBuilder(io.fabric8.openshift.api.model.Authentication instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AuthenticationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Authentication build() {
    Authentication buildable = new Authentication(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuthenticationBuilder that = (AuthenticationBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}