package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.util.Iterator;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
public class ClusterOperatorStatusFluentImpl<A extends io.fabric8.openshift.api.model.ClusterOperatorStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent<A>{
  public ClusterOperatorStatusFluentImpl() {
  }
  public ClusterOperatorStatusFluentImpl(io.fabric8.openshift.api.model.ClusterOperatorStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withExtension(instance.getExtension()); 
    this.withRelatedObjects(instance.getRelatedObjects()); 
    this.withVersions(instance.getVersions()); 
  }
  private java.util.List<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>();
  private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> extension;
  private java.util.List<io.fabric8.openshift.api.model.ObjectReferenceBuilder> relatedObjects =  new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();
  private java.util.List<io.fabric8.openshift.api.model.OperandVersionBuilder> versions =  new java.util.ArrayList<io.fabric8.openshift.api.model.OperandVersionBuilder>();
  public A addToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>();}
    io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>();}
    io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.ClusterOperatorStatusCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>();}
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item : items) {io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>();}
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item : items) {io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.ClusterOperatorStatusCondition... items) {
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item : items) {io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition> items) {
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item : items) {io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.openshift.api.model.ClusterOperatorStatusCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder>(); for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.ClusterOperatorStatusCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
    return (A)addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildExtension instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.HasMetadata getExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public A withExtension(io.fabric8.kubernetes.api.model.HasMetadata extension) {
    if (extension instanceof io.fabric8.openshift.api.model.ClusterVersion){ this.extension= new io.fabric8.openshift.api.model.ClusterVersionBuilder((io.fabric8.openshift.api.model.ClusterVersion)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.DNS){ this.extension= new io.fabric8.openshift.api.model.DNSBuilder((io.fabric8.openshift.api.model.DNS)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ImageStreamImport){ this.extension= new io.fabric8.openshift.api.model.ImageStreamImportBuilder((io.fabric8.openshift.api.model.ImageStreamImport)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Proxy){ this.extension= new io.fabric8.openshift.api.model.ProxyBuilder((io.fabric8.openshift.api.model.Proxy)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Project){ this.extension= new io.fabric8.openshift.api.model.ProjectBuilder((io.fabric8.openshift.api.model.Project)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ClusterOperator){ this.extension= new io.fabric8.openshift.api.model.ClusterOperatorBuilder((io.fabric8.openshift.api.model.ClusterOperator)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.BuildConfig){ this.extension= new io.fabric8.openshift.api.model.BuildConfigBuilder((io.fabric8.openshift.api.model.BuildConfig)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.HelmChartRepository){ this.extension= new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder((io.fabric8.openshift.api.model.HelmChartRepository)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Infrastructure){ this.extension= new io.fabric8.openshift.api.model.InfrastructureBuilder((io.fabric8.openshift.api.model.Infrastructure)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Scheduler){ this.extension= new io.fabric8.openshift.api.model.SchedulerBuilder((io.fabric8.openshift.api.model.Scheduler)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.RangeAllocation){ this.extension= new io.fabric8.openshift.api.model.RangeAllocationBuilder((io.fabric8.openshift.api.model.RangeAllocation)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Route){ this.extension= new io.fabric8.openshift.api.model.RouteBuilder((io.fabric8.openshift.api.model.Route)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ClusterNetwork){ this.extension= new io.fabric8.openshift.api.model.ClusterNetworkBuilder((io.fabric8.openshift.api.model.ClusterNetwork)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.OAuthAuthorizeToken){ this.extension= new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder((io.fabric8.openshift.api.model.OAuthAuthorizeToken)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.UserOAuthAccessToken){ this.extension= new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder((io.fabric8.openshift.api.model.UserOAuthAccessToken)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Ingress){ this.extension= new io.fabric8.openshift.api.model.IngressBuilder((io.fabric8.openshift.api.model.Ingress)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.OAuth){ this.extension= new io.fabric8.openshift.api.model.OAuthBuilder((io.fabric8.openshift.api.model.OAuth)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.OperatorHub){ this.extension= new io.fabric8.openshift.api.model.OperatorHubBuilder((io.fabric8.openshift.api.model.OperatorHub)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ClusterRoleBinding){ this.extension= new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder((io.fabric8.openshift.api.model.ClusterRoleBinding)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ClusterResourceQuota){ this.extension= new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder((io.fabric8.openshift.api.model.ClusterResourceQuota)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ProjectRequest){ this.extension= new io.fabric8.openshift.api.model.ProjectRequestBuilder((io.fabric8.openshift.api.model.ProjectRequest)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Template){ this.extension= new io.fabric8.openshift.api.model.TemplateBuilder((io.fabric8.openshift.api.model.Template)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.OAuthClientAuthorization){ this.extension= new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder((io.fabric8.openshift.api.model.OAuthClientAuthorization)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ClusterRole){ this.extension= new io.fabric8.openshift.api.model.ClusterRoleBuilder((io.fabric8.openshift.api.model.ClusterRole)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Authentication){ this.extension= new io.fabric8.openshift.api.model.AuthenticationBuilder((io.fabric8.openshift.api.model.Authentication)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ImageTag){ this.extension= new io.fabric8.openshift.api.model.ImageTagBuilder((io.fabric8.openshift.api.model.ImageTag)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.OAuthAccessToken){ this.extension= new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder((io.fabric8.openshift.api.model.OAuthAccessToken)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.DeploymentConfig){ this.extension= new io.fabric8.openshift.api.model.DeploymentConfigBuilder((io.fabric8.openshift.api.model.DeploymentConfig)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.RoleBinding){ this.extension= new io.fabric8.openshift.api.model.RoleBindingBuilder((io.fabric8.openshift.api.model.RoleBinding)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Image){ this.extension= new io.fabric8.openshift.api.model.ImageBuilder((io.fabric8.openshift.api.model.Image)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.APIServer){ this.extension= new io.fabric8.openshift.api.model.APIServerBuilder((io.fabric8.openshift.api.model.APIServer)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){ this.extension= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ImageStreamMapping){ this.extension= new io.fabric8.openshift.api.model.ImageStreamMappingBuilder((io.fabric8.openshift.api.model.ImageStreamMapping)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Role){ this.extension= new io.fabric8.openshift.api.model.RoleBuilder((io.fabric8.openshift.api.model.Role)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.BrokerTemplateInstance){ this.extension= new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder((io.fabric8.openshift.api.model.BrokerTemplateInstance)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.FeatureGate){ this.extension= new io.fabric8.openshift.api.model.FeatureGateBuilder((io.fabric8.openshift.api.model.FeatureGate)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.User){ this.extension= new io.fabric8.openshift.api.model.UserBuilder((io.fabric8.openshift.api.model.User)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ImageStreamImage){ this.extension= new io.fabric8.openshift.api.model.ImageStreamImageBuilder((io.fabric8.openshift.api.model.ImageStreamImage)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.TemplateInstance){ this.extension= new io.fabric8.openshift.api.model.TemplateInstanceBuilder((io.fabric8.openshift.api.model.TemplateInstance)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Build){ this.extension= new io.fabric8.openshift.api.model.BuildBuilder((io.fabric8.openshift.api.model.Build)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.RoleBindingRestriction){ this.extension= new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder((io.fabric8.openshift.api.model.RoleBindingRestriction)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ImageStreamTag){ this.extension= new io.fabric8.openshift.api.model.ImageStreamTagBuilder((io.fabric8.openshift.api.model.ImageStreamTag)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Group){ this.extension= new io.fabric8.openshift.api.model.GroupBuilder((io.fabric8.openshift.api.model.Group)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ImageSignature){ this.extension= new io.fabric8.openshift.api.model.ImageSignatureBuilder((io.fabric8.openshift.api.model.ImageSignature)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.HostSubnet){ this.extension= new io.fabric8.openshift.api.model.HostSubnetBuilder((io.fabric8.openshift.api.model.HostSubnet)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.AppliedClusterResourceQuota){ this.extension= new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder((io.fabric8.openshift.api.model.AppliedClusterResourceQuota)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.SecurityContextConstraints){ this.extension= new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder((io.fabric8.openshift.api.model.SecurityContextConstraints)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Console){ this.extension= new io.fabric8.openshift.api.model.ConsoleBuilder((io.fabric8.openshift.api.model.Console)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.BuildRequest){ this.extension= new io.fabric8.openshift.api.model.BuildRequestBuilder((io.fabric8.openshift.api.model.BuildRequest)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.EgressNetworkPolicy){ this.extension= new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder((io.fabric8.openshift.api.model.EgressNetworkPolicy)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.NetNamespace){ this.extension= new io.fabric8.openshift.api.model.NetNamespaceBuilder((io.fabric8.openshift.api.model.NetNamespace)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.UserIdentityMapping){ this.extension= new io.fabric8.openshift.api.model.UserIdentityMappingBuilder((io.fabric8.openshift.api.model.UserIdentityMapping)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.ImageStream){ this.extension= new io.fabric8.openshift.api.model.ImageStreamBuilder((io.fabric8.openshift.api.model.ImageStream)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Network){ this.extension= new io.fabric8.openshift.api.model.NetworkBuilder((io.fabric8.openshift.api.model.Network)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.OAuthClient){ this.extension= new io.fabric8.openshift.api.model.OAuthClientBuilder((io.fabric8.openshift.api.model.OAuthClient)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof io.fabric8.openshift.api.model.Identity){ this.extension= new io.fabric8.openshift.api.model.IdentityBuilder((io.fabric8.openshift.api.model.Identity)extension); _visitables.get("extension").add(this.extension);}
    return (A) this;
  }
  public java.lang.Boolean hasExtension() {
    return this.extension != null;
  }
  public A withClusterVersionExtension(io.fabric8.openshift.api.model.ClusterVersion clusterVersionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterVersionExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterVersionBuilder(clusterVersionExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterVersionExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtensionLike(io.fabric8.openshift.api.model.ClusterVersion item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterVersionExtensionNestedImpl(item);
  }
  public A withDNSExtension(io.fabric8.openshift.api.model.DNS dNSExtension) {
    _visitables.get("extension").remove(this.extension);
    if (dNSExtension!=null){ this.extension= new io.fabric8.openshift.api.model.DNSBuilder(dNSExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DNSExtensionNested<A> withNewDNSExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.DNSExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DNSExtensionNested<A> withNewDNSExtensionLike(io.fabric8.openshift.api.model.DNS item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.DNSExtensionNestedImpl(item);
  }
  public A withImageStreamImportExtension(io.fabric8.openshift.api.model.ImageStreamImport imageStreamImportExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageStreamImportExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageStreamImportBuilder(imageStreamImportExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<A> withNewImageStreamImportExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamImportExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<A> withNewImageStreamImportExtensionLike(io.fabric8.openshift.api.model.ImageStreamImport item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamImportExtensionNestedImpl(item);
  }
  public A withProxyExtension(io.fabric8.openshift.api.model.Proxy proxyExtension) {
    _visitables.get("extension").remove(this.extension);
    if (proxyExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ProxyBuilder(proxyExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ProxyExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtensionLike(io.fabric8.openshift.api.model.Proxy item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ProxyExtensionNestedImpl(item);
  }
  public A withProjectExtension(io.fabric8.openshift.api.model.Project projectExtension) {
    _visitables.get("extension").remove(this.extension);
    if (projectExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ProjectBuilder(projectExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ProjectExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtensionLike(io.fabric8.openshift.api.model.Project item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ProjectExtensionNestedImpl(item);
  }
  public A withClusterOperatorExtension(io.fabric8.openshift.api.model.ClusterOperator clusterOperatorExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterOperatorExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterOperatorBuilder(clusterOperatorExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterOperatorExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtensionLike(io.fabric8.openshift.api.model.ClusterOperator item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterOperatorExtensionNestedImpl(item);
  }
  public A withBuildConfigExtension(io.fabric8.openshift.api.model.BuildConfig buildConfigExtension) {
    _visitables.get("extension").remove(this.extension);
    if (buildConfigExtension!=null){ this.extension= new io.fabric8.openshift.api.model.BuildConfigBuilder(buildConfigExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildConfigExtensionNested<A> withNewBuildConfigExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BuildConfigExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildConfigExtensionNested<A> withNewBuildConfigExtensionLike(io.fabric8.openshift.api.model.BuildConfig item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BuildConfigExtensionNestedImpl(item);
  }
  public A withHelmChartRepositoryExtension(io.fabric8.openshift.api.model.HelmChartRepository helmChartRepositoryExtension) {
    _visitables.get("extension").remove(this.extension);
    if (helmChartRepositoryExtension!=null){ this.extension= new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(helmChartRepositoryExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HelmChartRepositoryExtensionNested<A> withNewHelmChartRepositoryExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.HelmChartRepositoryExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HelmChartRepositoryExtensionNested<A> withNewHelmChartRepositoryExtensionLike(io.fabric8.openshift.api.model.HelmChartRepository item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.HelmChartRepositoryExtensionNestedImpl(item);
  }
  public A withInfrastructureExtension(io.fabric8.openshift.api.model.Infrastructure infrastructureExtension) {
    _visitables.get("extension").remove(this.extension);
    if (infrastructureExtension!=null){ this.extension= new io.fabric8.openshift.api.model.InfrastructureBuilder(infrastructureExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.InfrastructureExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtensionLike(io.fabric8.openshift.api.model.Infrastructure item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.InfrastructureExtensionNestedImpl(item);
  }
  public A withSchedulerExtension(io.fabric8.openshift.api.model.Scheduler schedulerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (schedulerExtension!=null){ this.extension= new io.fabric8.openshift.api.model.SchedulerBuilder(schedulerExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.SchedulerExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtensionLike(io.fabric8.openshift.api.model.Scheduler item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.SchedulerExtensionNestedImpl(item);
  }
  public A withRangeAllocationExtension(io.fabric8.openshift.api.model.RangeAllocation rangeAllocationExtension) {
    _visitables.get("extension").remove(this.extension);
    if (rangeAllocationExtension!=null){ this.extension= new io.fabric8.openshift.api.model.RangeAllocationBuilder(rangeAllocationExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RangeAllocationExtensionNested<A> withNewRangeAllocationExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RangeAllocationExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RangeAllocationExtensionNested<A> withNewRangeAllocationExtensionLike(io.fabric8.openshift.api.model.RangeAllocation item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RangeAllocationExtensionNestedImpl(item);
  }
  public A withRouteExtension(io.fabric8.openshift.api.model.Route routeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (routeExtension!=null){ this.extension= new io.fabric8.openshift.api.model.RouteBuilder(routeExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RouteExtensionNested<A> withNewRouteExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RouteExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RouteExtensionNested<A> withNewRouteExtensionLike(io.fabric8.openshift.api.model.Route item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RouteExtensionNestedImpl(item);
  }
  public A withClusterNetworkExtension(io.fabric8.openshift.api.model.ClusterNetwork clusterNetworkExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterNetworkExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterNetworkBuilder(clusterNetworkExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<A> withNewClusterNetworkExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterNetworkExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<A> withNewClusterNetworkExtensionLike(io.fabric8.openshift.api.model.ClusterNetwork item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterNetworkExtensionNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenExtension(io.fabric8.openshift.api.model.OAuthAuthorizeToken oAuthAuthorizeTokenExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthAuthorizeTokenExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<A> withNewOAuthAuthorizeTokenExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthAuthorizeTokenExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<A> withNewOAuthAuthorizeTokenExtensionLike(io.fabric8.openshift.api.model.OAuthAuthorizeToken item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthAuthorizeTokenExtensionNestedImpl(item);
  }
  public A withUserOAuthAccessTokenExtension(io.fabric8.openshift.api.model.UserOAuthAccessToken userOAuthAccessTokenExtension) {
    _visitables.get("extension").remove(this.extension);
    if (userOAuthAccessTokenExtension!=null){ this.extension= new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(userOAuthAccessTokenExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserOAuthAccessTokenExtensionNested<A> withNewUserOAuthAccessTokenExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.UserOAuthAccessTokenExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserOAuthAccessTokenExtensionNested<A> withNewUserOAuthAccessTokenExtensionLike(io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.UserOAuthAccessTokenExtensionNestedImpl(item);
  }
  public A withIngressExtension(io.fabric8.openshift.api.model.Ingress ingressExtension) {
    _visitables.get("extension").remove(this.extension);
    if (ingressExtension!=null){ this.extension= new io.fabric8.openshift.api.model.IngressBuilder(ingressExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IngressExtensionNested<A> withNewIngressExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.IngressExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IngressExtensionNested<A> withNewIngressExtensionLike(io.fabric8.openshift.api.model.Ingress item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.IngressExtensionNestedImpl(item);
  }
  public A withOAuthExtension(io.fabric8.openshift.api.model.OAuth oAuthExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OAuthBuilder(oAuthExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtensionLike(io.fabric8.openshift.api.model.OAuth item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthExtensionNestedImpl(item);
  }
  public A withOperatorHubExtension(io.fabric8.openshift.api.model.OperatorHub operatorHubExtension) {
    _visitables.get("extension").remove(this.extension);
    if (operatorHubExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OperatorHubBuilder(operatorHubExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OperatorHubExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtensionLike(io.fabric8.openshift.api.model.OperatorHub item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OperatorHubExtensionNestedImpl(item);
  }
  public A withClusterRoleBindingExtension(io.fabric8.openshift.api.model.ClusterRoleBinding clusterRoleBindingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterRoleBindingExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(clusterRoleBindingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<A> withNewClusterRoleBindingExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterRoleBindingExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<A> withNewClusterRoleBindingExtensionLike(io.fabric8.openshift.api.model.ClusterRoleBinding item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterRoleBindingExtensionNestedImpl(item);
  }
  public A withClusterResourceQuotaExtension(io.fabric8.openshift.api.model.ClusterResourceQuota clusterResourceQuotaExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterResourceQuotaExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(clusterResourceQuotaExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<A> withNewClusterResourceQuotaExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterResourceQuotaExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<A> withNewClusterResourceQuotaExtensionLike(io.fabric8.openshift.api.model.ClusterResourceQuota item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterResourceQuotaExtensionNestedImpl(item);
  }
  public A withProjectRequestExtension(io.fabric8.openshift.api.model.ProjectRequest projectRequestExtension) {
    _visitables.get("extension").remove(this.extension);
    if (projectRequestExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ProjectRequestBuilder(projectRequestExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectRequestExtensionNested<A> withNewProjectRequestExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ProjectRequestExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectRequestExtensionNested<A> withNewProjectRequestExtensionLike(io.fabric8.openshift.api.model.ProjectRequest item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ProjectRequestExtensionNestedImpl(item);
  }
  public A withTemplateExtension(io.fabric8.openshift.api.model.Template templateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (templateExtension!=null){ this.extension= new io.fabric8.openshift.api.model.TemplateBuilder(templateExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateExtensionNested<A> withNewTemplateExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.TemplateExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateExtensionNested<A> withNewTemplateExtensionLike(io.fabric8.openshift.api.model.Template item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.TemplateExtensionNestedImpl(item);
  }
  public A withOAuthClientAuthorizationExtension(io.fabric8.openshift.api.model.OAuthClientAuthorization oAuthClientAuthorizationExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthClientAuthorizationExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(oAuthClientAuthorizationExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<A> withNewOAuthClientAuthorizationExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthClientAuthorizationExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<A> withNewOAuthClientAuthorizationExtensionLike(io.fabric8.openshift.api.model.OAuthClientAuthorization item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthClientAuthorizationExtensionNestedImpl(item);
  }
  public A withClusterRoleExtension(io.fabric8.openshift.api.model.ClusterRole clusterRoleExtension) {
    _visitables.get("extension").remove(this.extension);
    if (clusterRoleExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ClusterRoleBuilder(clusterRoleExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleExtensionNested<A> withNewClusterRoleExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterRoleExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleExtensionNested<A> withNewClusterRoleExtensionLike(io.fabric8.openshift.api.model.ClusterRole item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ClusterRoleExtensionNestedImpl(item);
  }
  public A withAuthenticationExtension(io.fabric8.openshift.api.model.Authentication authenticationExtension) {
    _visitables.get("extension").remove(this.extension);
    if (authenticationExtension!=null){ this.extension= new io.fabric8.openshift.api.model.AuthenticationBuilder(authenticationExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AuthenticationExtensionNested<A> withNewAuthenticationExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.AuthenticationExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AuthenticationExtensionNested<A> withNewAuthenticationExtensionLike(io.fabric8.openshift.api.model.Authentication item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.AuthenticationExtensionNestedImpl(item);
  }
  public A withImageTagExtension(io.fabric8.openshift.api.model.ImageTag imageTagExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageTagExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageTagBuilder(imageTagExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageTagExtensionNested<A> withNewImageTagExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageTagExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageTagExtensionNested<A> withNewImageTagExtensionLike(io.fabric8.openshift.api.model.ImageTag item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageTagExtensionNestedImpl(item);
  }
  public A withOAuthAccessTokenExtension(io.fabric8.openshift.api.model.OAuthAccessToken oAuthAccessTokenExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthAccessTokenExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(oAuthAccessTokenExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<A> withNewOAuthAccessTokenExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthAccessTokenExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<A> withNewOAuthAccessTokenExtensionLike(io.fabric8.openshift.api.model.OAuthAccessToken item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthAccessTokenExtensionNestedImpl(item);
  }
  public A withDeploymentConfigExtension(io.fabric8.openshift.api.model.DeploymentConfig deploymentConfigExtension) {
    _visitables.get("extension").remove(this.extension);
    if (deploymentConfigExtension!=null){ this.extension= new io.fabric8.openshift.api.model.DeploymentConfigBuilder(deploymentConfigExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<A> withNewDeploymentConfigExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.DeploymentConfigExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<A> withNewDeploymentConfigExtensionLike(io.fabric8.openshift.api.model.DeploymentConfig item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.DeploymentConfigExtensionNestedImpl(item);
  }
  public A withRoleBindingExtension(io.fabric8.openshift.api.model.RoleBinding roleBindingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (roleBindingExtension!=null){ this.extension= new io.fabric8.openshift.api.model.RoleBindingBuilder(roleBindingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingExtensionNested<A> withNewRoleBindingExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RoleBindingExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingExtensionNested<A> withNewRoleBindingExtensionLike(io.fabric8.openshift.api.model.RoleBinding item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RoleBindingExtensionNestedImpl(item);
  }
  public A withImageExtension(io.fabric8.openshift.api.model.Image imageExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageBuilder(imageExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtensionLike(io.fabric8.openshift.api.model.Image item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageExtensionNestedImpl(item);
  }
  public A withAPIServerExtension(io.fabric8.openshift.api.model.APIServer aPIServerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIServerExtension!=null){ this.extension= new io.fabric8.openshift.api.model.APIServerBuilder(aPIServerExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.APIServerExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtensionLike(io.fabric8.openshift.api.model.APIServer item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.APIServerExtensionNestedImpl(item);
  }
  public A withPersistentVolumeClaimExtension(io.fabric8.kubernetes.api.model.PersistentVolumeClaim persistentVolumeClaimExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimExtension!=null){ this.extension= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(persistentVolumeClaimExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.PersistentVolumeClaimExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtensionLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.PersistentVolumeClaimExtensionNestedImpl(item);
  }
  public A withImageStreamMappingExtension(io.fabric8.openshift.api.model.ImageStreamMapping imageStreamMappingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageStreamMappingExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(imageStreamMappingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<A> withNewImageStreamMappingExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamMappingExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<A> withNewImageStreamMappingExtensionLike(io.fabric8.openshift.api.model.ImageStreamMapping item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamMappingExtensionNestedImpl(item);
  }
  public A withRoleExtension(io.fabric8.openshift.api.model.Role roleExtension) {
    _visitables.get("extension").remove(this.extension);
    if (roleExtension!=null){ this.extension= new io.fabric8.openshift.api.model.RoleBuilder(roleExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleExtensionNested<A> withNewRoleExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RoleExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleExtensionNested<A> withNewRoleExtensionLike(io.fabric8.openshift.api.model.Role item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RoleExtensionNestedImpl(item);
  }
  public A withBrokerTemplateInstanceExtension(io.fabric8.openshift.api.model.BrokerTemplateInstance brokerTemplateInstanceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (brokerTemplateInstanceExtension!=null){ this.extension= new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(brokerTemplateInstanceExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BrokerTemplateInstanceExtensionNested<A> withNewBrokerTemplateInstanceExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BrokerTemplateInstanceExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BrokerTemplateInstanceExtensionNested<A> withNewBrokerTemplateInstanceExtensionLike(io.fabric8.openshift.api.model.BrokerTemplateInstance item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BrokerTemplateInstanceExtensionNestedImpl(item);
  }
  public A withFeatureGateExtension(io.fabric8.openshift.api.model.FeatureGate featureGateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (featureGateExtension!=null){ this.extension= new io.fabric8.openshift.api.model.FeatureGateBuilder(featureGateExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.FeatureGateExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtensionLike(io.fabric8.openshift.api.model.FeatureGate item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.FeatureGateExtensionNestedImpl(item);
  }
  public A withUserExtension(io.fabric8.openshift.api.model.User userExtension) {
    _visitables.get("extension").remove(this.extension);
    if (userExtension!=null){ this.extension= new io.fabric8.openshift.api.model.UserBuilder(userExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserExtensionNested<A> withNewUserExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.UserExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserExtensionNested<A> withNewUserExtensionLike(io.fabric8.openshift.api.model.User item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.UserExtensionNestedImpl(item);
  }
  public A withImageStreamImageExtension(io.fabric8.openshift.api.model.ImageStreamImage imageStreamImageExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageStreamImageExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageStreamImageBuilder(imageStreamImageExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<A> withNewImageStreamImageExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamImageExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<A> withNewImageStreamImageExtensionLike(io.fabric8.openshift.api.model.ImageStreamImage item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamImageExtensionNestedImpl(item);
  }
  public A withTemplateInstanceExtension(io.fabric8.openshift.api.model.TemplateInstance templateInstanceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (templateInstanceExtension!=null){ this.extension= new io.fabric8.openshift.api.model.TemplateInstanceBuilder(templateInstanceExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateInstanceExtensionNested<A> withNewTemplateInstanceExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.TemplateInstanceExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateInstanceExtensionNested<A> withNewTemplateInstanceExtensionLike(io.fabric8.openshift.api.model.TemplateInstance item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.TemplateInstanceExtensionNestedImpl(item);
  }
  public A withBuildExtension(io.fabric8.openshift.api.model.Build buildExtension) {
    _visitables.get("extension").remove(this.extension);
    if (buildExtension!=null){ this.extension= new io.fabric8.openshift.api.model.BuildBuilder(buildExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BuildExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtensionLike(io.fabric8.openshift.api.model.Build item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BuildExtensionNestedImpl(item);
  }
  public A withRoleBindingRestrictionExtension(io.fabric8.openshift.api.model.RoleBindingRestriction roleBindingRestrictionExtension) {
    _visitables.get("extension").remove(this.extension);
    if (roleBindingRestrictionExtension!=null){ this.extension= new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(roleBindingRestrictionExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<A> withNewRoleBindingRestrictionExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RoleBindingRestrictionExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<A> withNewRoleBindingRestrictionExtensionLike(io.fabric8.openshift.api.model.RoleBindingRestriction item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RoleBindingRestrictionExtensionNestedImpl(item);
  }
  public A withImageStreamTagExtension(io.fabric8.openshift.api.model.ImageStreamTag imageStreamTagExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageStreamTagExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageStreamTagBuilder(imageStreamTagExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<A> withNewImageStreamTagExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamTagExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<A> withNewImageStreamTagExtensionLike(io.fabric8.openshift.api.model.ImageStreamTag item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamTagExtensionNestedImpl(item);
  }
  public A withGroupExtension(io.fabric8.openshift.api.model.Group groupExtension) {
    _visitables.get("extension").remove(this.extension);
    if (groupExtension!=null){ this.extension= new io.fabric8.openshift.api.model.GroupBuilder(groupExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.GroupExtensionNested<A> withNewGroupExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.GroupExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.GroupExtensionNested<A> withNewGroupExtensionLike(io.fabric8.openshift.api.model.Group item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.GroupExtensionNestedImpl(item);
  }
  public A withImageSignatureExtension(io.fabric8.openshift.api.model.ImageSignature imageSignatureExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageSignatureExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageSignatureBuilder(imageSignatureExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageSignatureExtensionNested<A> withNewImageSignatureExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageSignatureExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageSignatureExtensionNested<A> withNewImageSignatureExtensionLike(io.fabric8.openshift.api.model.ImageSignature item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageSignatureExtensionNestedImpl(item);
  }
  public A withHostSubnetExtension(io.fabric8.openshift.api.model.HostSubnet hostSubnetExtension) {
    _visitables.get("extension").remove(this.extension);
    if (hostSubnetExtension!=null){ this.extension= new io.fabric8.openshift.api.model.HostSubnetBuilder(hostSubnetExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HostSubnetExtensionNested<A> withNewHostSubnetExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.HostSubnetExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HostSubnetExtensionNested<A> withNewHostSubnetExtensionLike(io.fabric8.openshift.api.model.HostSubnet item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.HostSubnetExtensionNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaExtension(io.fabric8.openshift.api.model.AppliedClusterResourceQuota appliedClusterResourceQuotaExtension) {
    _visitables.get("extension").remove(this.extension);
    if (appliedClusterResourceQuotaExtension!=null){ this.extension= new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<A> withNewAppliedClusterResourceQuotaExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.AppliedClusterResourceQuotaExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<A> withNewAppliedClusterResourceQuotaExtensionLike(io.fabric8.openshift.api.model.AppliedClusterResourceQuota item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.AppliedClusterResourceQuotaExtensionNestedImpl(item);
  }
  public A withSecurityContextConstraintsExtension(io.fabric8.openshift.api.model.SecurityContextConstraints securityContextConstraintsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (securityContextConstraintsExtension!=null){ this.extension= new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(securityContextConstraintsExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<A> withNewSecurityContextConstraintsExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.SecurityContextConstraintsExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<A> withNewSecurityContextConstraintsExtensionLike(io.fabric8.openshift.api.model.SecurityContextConstraints item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.SecurityContextConstraintsExtensionNestedImpl(item);
  }
  public A withConsoleExtension(io.fabric8.openshift.api.model.Console consoleExtension) {
    _visitables.get("extension").remove(this.extension);
    if (consoleExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ConsoleBuilder(consoleExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConsoleExtensionNested<A> withNewConsoleExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ConsoleExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConsoleExtensionNested<A> withNewConsoleExtensionLike(io.fabric8.openshift.api.model.Console item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ConsoleExtensionNestedImpl(item);
  }
  public A withBuildRequestExtension(io.fabric8.openshift.api.model.BuildRequest buildRequestExtension) {
    _visitables.get("extension").remove(this.extension);
    if (buildRequestExtension!=null){ this.extension= new io.fabric8.openshift.api.model.BuildRequestBuilder(buildRequestExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildRequestExtensionNested<A> withNewBuildRequestExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BuildRequestExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildRequestExtensionNested<A> withNewBuildRequestExtensionLike(io.fabric8.openshift.api.model.BuildRequest item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.BuildRequestExtensionNestedImpl(item);
  }
  public A withEgressNetworkPolicyExtension(io.fabric8.openshift.api.model.EgressNetworkPolicy egressNetworkPolicyExtension) {
    _visitables.get("extension").remove(this.extension);
    if (egressNetworkPolicyExtension!=null){ this.extension= new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(egressNetworkPolicyExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<A> withNewEgressNetworkPolicyExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.EgressNetworkPolicyExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<A> withNewEgressNetworkPolicyExtensionLike(io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.EgressNetworkPolicyExtensionNestedImpl(item);
  }
  public A withNetNamespaceExtension(io.fabric8.openshift.api.model.NetNamespace netNamespaceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (netNamespaceExtension!=null){ this.extension= new io.fabric8.openshift.api.model.NetNamespaceBuilder(netNamespaceExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetNamespaceExtensionNested<A> withNewNetNamespaceExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.NetNamespaceExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetNamespaceExtensionNested<A> withNewNetNamespaceExtensionLike(io.fabric8.openshift.api.model.NetNamespace item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.NetNamespaceExtensionNestedImpl(item);
  }
  public A withUserIdentityMappingExtension(io.fabric8.openshift.api.model.UserIdentityMapping userIdentityMappingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (userIdentityMappingExtension!=null){ this.extension= new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(userIdentityMappingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserIdentityMappingExtensionNested<A> withNewUserIdentityMappingExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.UserIdentityMappingExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserIdentityMappingExtensionNested<A> withNewUserIdentityMappingExtensionLike(io.fabric8.openshift.api.model.UserIdentityMapping item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.UserIdentityMappingExtensionNestedImpl(item);
  }
  public A withImageStreamExtension(io.fabric8.openshift.api.model.ImageStream imageStreamExtension) {
    _visitables.get("extension").remove(this.extension);
    if (imageStreamExtension!=null){ this.extension= new io.fabric8.openshift.api.model.ImageStreamBuilder(imageStreamExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamExtensionNested<A> withNewImageStreamExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamExtensionNested<A> withNewImageStreamExtensionLike(io.fabric8.openshift.api.model.ImageStream item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.ImageStreamExtensionNestedImpl(item);
  }
  public A withNetworkExtension(io.fabric8.openshift.api.model.Network networkExtension) {
    _visitables.get("extension").remove(this.extension);
    if (networkExtension!=null){ this.extension= new io.fabric8.openshift.api.model.NetworkBuilder(networkExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetworkExtensionNested<A> withNewNetworkExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.NetworkExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetworkExtensionNested<A> withNewNetworkExtensionLike(io.fabric8.openshift.api.model.Network item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.NetworkExtensionNestedImpl(item);
  }
  public A withOAuthClientExtension(io.fabric8.openshift.api.model.OAuthClient oAuthClientExtension) {
    _visitables.get("extension").remove(this.extension);
    if (oAuthClientExtension!=null){ this.extension= new io.fabric8.openshift.api.model.OAuthClientBuilder(oAuthClientExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientExtensionNested<A> withNewOAuthClientExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthClientExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientExtensionNested<A> withNewOAuthClientExtensionLike(io.fabric8.openshift.api.model.OAuthClient item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.OAuthClientExtensionNestedImpl(item);
  }
  public A withIdentityExtension(io.fabric8.openshift.api.model.Identity identityExtension) {
    _visitables.get("extension").remove(this.extension);
    if (identityExtension!=null){ this.extension= new io.fabric8.openshift.api.model.IdentityBuilder(identityExtension); _visitables.get("extension").add(this.extension);} return (A) this;
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IdentityExtensionNested<A> withNewIdentityExtension() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.IdentityExtensionNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IdentityExtensionNested<A> withNewIdentityExtensionLike(io.fabric8.openshift.api.model.Identity item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.IdentityExtensionNestedImpl(item);
  }
  public A addToRelatedObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(index >= 0 ? index : _visitables.get("relatedObjects").size(), builder);this.relatedObjects.add(index >= 0 ? index : relatedObjects.size(), builder); return (A)this;
  }
  public A setToRelatedObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("relatedObjects").size()) { _visitables.get("relatedObjects").add(builder); } else { _visitables.get("relatedObjects").set(index, builder);}
    if (index < 0 || index >= relatedObjects.size()) { relatedObjects.add(builder); } else { relatedObjects.set(index, builder);}
     return (A)this;
  }
  public A addToRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  public A addAllToRelatedObjects(java.util.Collection<io.fabric8.openshift.api.model.ObjectReference> items) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  public A removeFromRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items) {
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelatedObjects(java.util.Collection<io.fabric8.openshift.api.model.ObjectReference> items) {
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelatedObjects(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    if (relatedObjects == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ObjectReferenceBuilder> each = relatedObjects.iterator();
    final List visitables = _visitables.get("relatedObjects");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelatedObjects instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ObjectReference> getRelatedObjects() {
    return build(relatedObjects);
  }
  public java.util.List<io.fabric8.openshift.api.model.ObjectReference> buildRelatedObjects() {
    return build(relatedObjects);
  }
  public io.fabric8.openshift.api.model.ObjectReference buildRelatedObject(java.lang.Integer index) {
    return this.relatedObjects.get(index).build();
  }
  public io.fabric8.openshift.api.model.ObjectReference buildFirstRelatedObject() {
    return this.relatedObjects.get(0).build();
  }
  public io.fabric8.openshift.api.model.ObjectReference buildLastRelatedObject() {
    return this.relatedObjects.get(relatedObjects.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ObjectReference buildMatchingRelatedObject(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRelatedObject(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelatedObjects(java.util.List<io.fabric8.openshift.api.model.ObjectReference> relatedObjects) {
    if (this.relatedObjects != null) { _visitables.get("relatedObjects").removeAll(this.relatedObjects);}
    if (relatedObjects != null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>(); for (io.fabric8.openshift.api.model.ObjectReference item : relatedObjects){this.addToRelatedObjects(item);}} else { this.relatedObjects = null;} return (A) this;
  }
  public A withRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... relatedObjects) {
    if (this.relatedObjects != null) {this.relatedObjects.clear();}
    if (relatedObjects != null) {for (io.fabric8.openshift.api.model.ObjectReference item :relatedObjects){ this.addToRelatedObjects(item);}} return (A) this;
  }
  public java.lang.Boolean hasRelatedObjects() {
    return relatedObjects != null && !relatedObjects.isEmpty();
  }
  public A addNewRelatedObject(java.lang.String group,java.lang.String name,java.lang.String namespace,java.lang.String resource) {
    return (A)addToRelatedObjects(new ObjectReference(group, name, namespace, resource));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObject() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObjectLike(io.fabric8.openshift.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> setNewRelatedObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editRelatedObject(java.lang.Integer index) {
    if (relatedObjects.size() <= index) throw new RuntimeException("Can't edit relatedObjects. Index exceeds size.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editFirstRelatedObject() {
    if (relatedObjects.size() == 0) throw new RuntimeException("Can't edit first relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(0, buildRelatedObject(0));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editLastRelatedObject() {
    int index = relatedObjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editMatchingRelatedObject(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relatedObjects.size();i++) { 
    if (predicate.test(relatedObjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relatedObjects. No match found.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public A addToVersions(java.lang.Integer index,io.fabric8.openshift.api.model.OperandVersion item) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.openshift.api.model.OperandVersionBuilder>();}
    io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
  }
  public A setToVersions(java.lang.Integer index,io.fabric8.openshift.api.model.OperandVersion item) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.openshift.api.model.OperandVersionBuilder>();}
    io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);
    if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
    if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
     return (A)this;
  }
  public A addToVersions(io.fabric8.openshift.api.model.OperandVersion... items) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.openshift.api.model.OperandVersionBuilder>();}
    for (io.fabric8.openshift.api.model.OperandVersion item : items) {io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A addAllToVersions(java.util.Collection<io.fabric8.openshift.api.model.OperandVersion> items) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.openshift.api.model.OperandVersionBuilder>();}
    for (io.fabric8.openshift.api.model.OperandVersion item : items) {io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A removeFromVersions(io.fabric8.openshift.api.model.OperandVersion... items) {
    for (io.fabric8.openshift.api.model.OperandVersion item : items) {io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeAllFromVersions(java.util.Collection<io.fabric8.openshift.api.model.OperandVersion> items) {
    for (io.fabric8.openshift.api.model.OperandVersion item : items) {io.fabric8.openshift.api.model.OperandVersionBuilder builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVersions(java.util.function.Predicate<io.fabric8.openshift.api.model.OperandVersionBuilder> predicate) {
    if (versions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.OperandVersionBuilder> each = versions.iterator();
    final List visitables = _visitables.get("versions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.OperandVersionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVersions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.OperandVersion> getVersions() {
    return build(versions);
  }
  public java.util.List<io.fabric8.openshift.api.model.OperandVersion> buildVersions() {
    return build(versions);
  }
  public io.fabric8.openshift.api.model.OperandVersion buildVersion(java.lang.Integer index) {
    return this.versions.get(index).build();
  }
  public io.fabric8.openshift.api.model.OperandVersion buildFirstVersion() {
    return this.versions.get(0).build();
  }
  public io.fabric8.openshift.api.model.OperandVersion buildLastVersion() {
    return this.versions.get(versions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.OperandVersion buildMatchingVersion(java.util.function.Predicate<io.fabric8.openshift.api.model.OperandVersionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.OperandVersionBuilder item: versions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingVersion(java.util.function.Predicate<io.fabric8.openshift.api.model.OperandVersionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.OperandVersionBuilder item: versions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVersions(java.util.List<io.fabric8.openshift.api.model.OperandVersion> versions) {
    if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
    if (versions != null) {this.versions = new java.util.ArrayList<io.fabric8.openshift.api.model.OperandVersionBuilder>(); for (io.fabric8.openshift.api.model.OperandVersion item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
  }
  public A withVersions(io.fabric8.openshift.api.model.OperandVersion... versions) {
    if (this.versions != null) {this.versions.clear();}
    if (versions != null) {for (io.fabric8.openshift.api.model.OperandVersion item :versions){ this.addToVersions(item);}} return (A) this;
  }
  public java.lang.Boolean hasVersions() {
    return versions != null && !versions.isEmpty();
  }
  public A addNewVersion(java.lang.String name,java.lang.String version) {
    return (A)addToVersions(new OperandVersion(name, version));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> addNewVersion() {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.VersionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> addNewVersionLike(io.fabric8.openshift.api.model.OperandVersion item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.VersionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> setNewVersionLike(java.lang.Integer index,io.fabric8.openshift.api.model.OperandVersion item) {
    return new io.fabric8.openshift.api.model.ClusterOperatorStatusFluentImpl.VersionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editVersion(java.lang.Integer index) {
    if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editFirstVersion() {
    if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
    return setNewVersionLike(0, buildVersion(0));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editLastVersion() {
    int index = versions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editMatchingVersion(java.util.function.Predicate<io.fabric8.openshift.api.model.OperandVersionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<versions.size();i++) { 
    if (predicate.test(versions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterOperatorStatusFluentImpl that = (ClusterOperatorStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (relatedObjects != null ? !relatedObjects.equals(that.relatedObjects) :that.relatedObjects != null) return false;
    if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  extension,  relatedObjects,  versions,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterOperatorStatusConditionFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperatorStatusCondition item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class ClusterVersionExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterVersionFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterVersionExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterVersionExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterVersionExtensionNestedImpl(io.fabric8.openshift.api.model.ClusterVersion item) {
      this.builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(this, item);
    }
    ClusterVersionExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterVersionBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterVersionExtension() {
      return and();
    }
    
  }
  public class DNSExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.DNSFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DNSExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DNSExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DNSExtensionNestedImpl(io.fabric8.openshift.api.model.DNS item) {
      this.builder = new io.fabric8.openshift.api.model.DNSBuilder(this, item);
    }
    DNSExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.DNSBuilder(this);
    }
    io.fabric8.openshift.api.model.DNSBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endDNSExtension() {
      return and();
    }
    
  }
  public class ImageStreamImportExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ImageStreamImportFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamImportExtensionNestedImpl(io.fabric8.openshift.api.model.ImageStreamImport item) {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamImportBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageStreamImportExtension() {
      return and();
    }
    
  }
  public class ProxyExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ProxyFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProxyExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProxyExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProxyExtensionNestedImpl(io.fabric8.openshift.api.model.Proxy item) {
      this.builder = new io.fabric8.openshift.api.model.ProxyBuilder(this, item);
    }
    ProxyExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ProxyBuilder(this);
    }
    io.fabric8.openshift.api.model.ProxyBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endProxyExtension() {
      return and();
    }
    
  }
  public class ProjectExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ProjectFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProjectExtensionNestedImpl(io.fabric8.openshift.api.model.Project item) {
      this.builder = new io.fabric8.openshift.api.model.ProjectBuilder(this, item);
    }
    ProjectExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ProjectBuilder(this);
    }
    io.fabric8.openshift.api.model.ProjectBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endProjectExtension() {
      return and();
    }
    
  }
  public class ClusterOperatorExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterOperatorFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterOperatorExtensionNestedImpl(io.fabric8.openshift.api.model.ClusterOperator item) {
      this.builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(this, item);
    }
    ClusterOperatorExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterOperatorBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterOperatorExtension() {
      return and();
    }
    
  }
  public class BuildConfigExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.BuildConfigFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildConfigExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildConfigExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildConfigExtensionNestedImpl(io.fabric8.openshift.api.model.BuildConfig item) {
      this.builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(this, item);
    }
    BuildConfigExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildConfigBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endBuildConfigExtension() {
      return and();
    }
    
  }
  public class HelmChartRepositoryExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.HelmChartRepositoryFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HelmChartRepositoryExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HelmChartRepositoryExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HelmChartRepositoryExtensionNestedImpl(io.fabric8.openshift.api.model.HelmChartRepository item) {
      this.builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(this);
    }
    io.fabric8.openshift.api.model.HelmChartRepositoryBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endHelmChartRepositoryExtension() {
      return and();
    }
    
  }
  public class InfrastructureExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.InfrastructureFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.InfrastructureExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.InfrastructureExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    InfrastructureExtensionNestedImpl(io.fabric8.openshift.api.model.Infrastructure item) {
      this.builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(this, item);
    }
    InfrastructureExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(this);
    }
    io.fabric8.openshift.api.model.InfrastructureBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endInfrastructureExtension() {
      return and();
    }
    
  }
  public class SchedulerExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.SchedulerFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SchedulerExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SchedulerExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SchedulerExtensionNestedImpl(io.fabric8.openshift.api.model.Scheduler item) {
      this.builder = new io.fabric8.openshift.api.model.SchedulerBuilder(this, item);
    }
    SchedulerExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SchedulerBuilder(this);
    }
    io.fabric8.openshift.api.model.SchedulerBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endSchedulerExtension() {
      return and();
    }
    
  }
  public class RangeAllocationExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.RangeAllocationFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RangeAllocationExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RangeAllocationExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RangeAllocationExtensionNestedImpl(io.fabric8.openshift.api.model.RangeAllocation item) {
      this.builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(this, item);
    }
    RangeAllocationExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(this);
    }
    io.fabric8.openshift.api.model.RangeAllocationBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endRangeAllocationExtension() {
      return and();
    }
    
  }
  public class RouteExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.RouteFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RouteExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RouteExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RouteExtensionNestedImpl(io.fabric8.openshift.api.model.Route item) {
      this.builder = new io.fabric8.openshift.api.model.RouteBuilder(this, item);
    }
    RouteExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RouteBuilder(this);
    }
    io.fabric8.openshift.api.model.RouteBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endRouteExtension() {
      return and();
    }
    
  }
  public class ClusterNetworkExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterNetworkFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterNetworkExtensionNestedImpl(io.fabric8.openshift.api.model.ClusterNetwork item) {
      this.builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterNetworkBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterNetworkExtension() {
      return and();
    }
    
  }
  public class OAuthAuthorizeTokenExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthAuthorizeTokenExtensionNestedImpl(io.fabric8.openshift.api.model.OAuthAuthorizeToken item) {
      this.builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthAuthorizeTokenExtension() {
      return and();
    }
    
  }
  public class UserOAuthAccessTokenExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.UserOAuthAccessTokenFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserOAuthAccessTokenExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserOAuthAccessTokenExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserOAuthAccessTokenExtensionNestedImpl(io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
      this.builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endUserOAuthAccessTokenExtension() {
      return and();
    }
    
  }
  public class IngressExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.IngressFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IngressExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IngressExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IngressExtensionNestedImpl(io.fabric8.openshift.api.model.Ingress item) {
      this.builder = new io.fabric8.openshift.api.model.IngressBuilder(this, item);
    }
    IngressExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.IngressBuilder(this);
    }
    io.fabric8.openshift.api.model.IngressBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endIngressExtension() {
      return and();
    }
    
  }
  public class OAuthExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthExtensionNestedImpl(io.fabric8.openshift.api.model.OAuth item) {
      this.builder = new io.fabric8.openshift.api.model.OAuthBuilder(this, item);
    }
    OAuthExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthExtension() {
      return and();
    }
    
  }
  public class OperatorHubExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.OperatorHubFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OperatorHubExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OperatorHubExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OperatorHubExtensionNestedImpl(io.fabric8.openshift.api.model.OperatorHub item) {
      this.builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(this, item);
    }
    OperatorHubExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(this);
    }
    io.fabric8.openshift.api.model.OperatorHubBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOperatorHubExtension() {
      return and();
    }
    
  }
  public class ClusterRoleBindingExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterRoleBindingExtensionNestedImpl(io.fabric8.openshift.api.model.ClusterRoleBinding item) {
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterRoleBindingBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterRoleBindingExtension() {
      return and();
    }
    
  }
  public class ClusterResourceQuotaExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterResourceQuotaFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterResourceQuotaExtensionNestedImpl(io.fabric8.openshift.api.model.ClusterResourceQuota item) {
      this.builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterResourceQuotaExtension() {
      return and();
    }
    
  }
  public class ProjectRequestExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ProjectRequestFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectRequestExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectRequestExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProjectRequestExtensionNestedImpl(io.fabric8.openshift.api.model.ProjectRequest item) {
      this.builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(this, item);
    }
    ProjectRequestExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(this);
    }
    io.fabric8.openshift.api.model.ProjectRequestBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endProjectRequestExtension() {
      return and();
    }
    
  }
  public class TemplateExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.TemplateFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateExtensionNestedImpl(io.fabric8.openshift.api.model.Template item) {
      this.builder = new io.fabric8.openshift.api.model.TemplateBuilder(this, item);
    }
    TemplateExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TemplateBuilder(this);
    }
    io.fabric8.openshift.api.model.TemplateBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endTemplateExtension() {
      return and();
    }
    
  }
  public class OAuthClientAuthorizationExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthClientAuthorizationExtensionNestedImpl(io.fabric8.openshift.api.model.OAuthClientAuthorization item) {
      this.builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthClientAuthorizationExtension() {
      return and();
    }
    
  }
  public class ClusterRoleExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterRoleFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterRoleExtensionNestedImpl(io.fabric8.openshift.api.model.ClusterRole item) {
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(this, item);
    }
    ClusterRoleExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterRoleBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endClusterRoleExtension() {
      return and();
    }
    
  }
  public class AuthenticationExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.AuthenticationFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AuthenticationExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AuthenticationExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AuthenticationExtensionNestedImpl(io.fabric8.openshift.api.model.Authentication item) {
      this.builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(this, item);
    }
    AuthenticationExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(this);
    }
    io.fabric8.openshift.api.model.AuthenticationBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endAuthenticationExtension() {
      return and();
    }
    
  }
  public class ImageTagExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ImageTagFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageTagExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageTagExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageTagExtensionNestedImpl(io.fabric8.openshift.api.model.ImageTag item) {
      this.builder = new io.fabric8.openshift.api.model.ImageTagBuilder(this, item);
    }
    ImageTagExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageTagBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageTagBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageTagExtension() {
      return and();
    }
    
  }
  public class OAuthAccessTokenExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthAccessTokenFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthAccessTokenExtensionNestedImpl(io.fabric8.openshift.api.model.OAuthAccessToken item) {
      this.builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthAccessTokenBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthAccessTokenExtension() {
      return and();
    }
    
  }
  public class DeploymentConfigExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.DeploymentConfigFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DeploymentConfigExtensionNestedImpl(io.fabric8.openshift.api.model.DeploymentConfig item) {
      this.builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.DeploymentConfigBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endDeploymentConfigExtension() {
      return and();
    }
    
  }
  public class RoleBindingExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.RoleBindingFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleBindingExtensionNestedImpl(io.fabric8.openshift.api.model.RoleBinding item) {
      this.builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(this, item);
    }
    RoleBindingExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBindingBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endRoleBindingExtension() {
      return and();
    }
    
  }
  public class ImageExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ImageFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageExtensionNestedImpl(io.fabric8.openshift.api.model.Image item) {
      this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this, item);
    }
    ImageExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageExtension() {
      return and();
    }
    
  }
  public class APIServerExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.APIServerFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.APIServerExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.APIServerExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    APIServerExtensionNestedImpl(io.fabric8.openshift.api.model.APIServer item) {
      this.builder = new io.fabric8.openshift.api.model.APIServerBuilder(this, item);
    }
    APIServerExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.APIServerBuilder(this);
    }
    io.fabric8.openshift.api.model.APIServerBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIServerExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimExtensionNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeClaimExtensionNestedImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimExtensionNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimExtension() {
      return and();
    }
    
  }
  public class ImageStreamMappingExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ImageStreamMappingFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamMappingExtensionNestedImpl(io.fabric8.openshift.api.model.ImageStreamMapping item) {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamMappingBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageStreamMappingExtension() {
      return and();
    }
    
  }
  public class RoleExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.RoleFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleExtensionNestedImpl(io.fabric8.openshift.api.model.Role item) {
      this.builder = new io.fabric8.openshift.api.model.RoleBuilder(this, item);
    }
    RoleExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RoleBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endRoleExtension() {
      return and();
    }
    
  }
  public class BrokerTemplateInstanceExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.BrokerTemplateInstanceFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BrokerTemplateInstanceExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BrokerTemplateInstanceExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BrokerTemplateInstanceExtensionNestedImpl(io.fabric8.openshift.api.model.BrokerTemplateInstance item) {
      this.builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(this);
    }
    io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endBrokerTemplateInstanceExtension() {
      return and();
    }
    
  }
  public class FeatureGateExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.FeatureGateFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.FeatureGateExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.FeatureGateExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FeatureGateExtensionNestedImpl(io.fabric8.openshift.api.model.FeatureGate item) {
      this.builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(this, item);
    }
    FeatureGateExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(this);
    }
    io.fabric8.openshift.api.model.FeatureGateBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endFeatureGateExtension() {
      return and();
    }
    
  }
  public class UserExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.UserFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserExtensionNestedImpl(io.fabric8.openshift.api.model.User item) {
      this.builder = new io.fabric8.openshift.api.model.UserBuilder(this, item);
    }
    UserExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.UserBuilder(this);
    }
    io.fabric8.openshift.api.model.UserBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endUserExtension() {
      return and();
    }
    
  }
  public class ImageStreamImageExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ImageStreamImageFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamImageExtensionNestedImpl(io.fabric8.openshift.api.model.ImageStreamImage item) {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamImageBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageStreamImageExtension() {
      return and();
    }
    
  }
  public class TemplateInstanceExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.TemplateInstanceFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateInstanceExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateInstanceExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateInstanceExtensionNestedImpl(io.fabric8.openshift.api.model.TemplateInstance item) {
      this.builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(this);
    }
    io.fabric8.openshift.api.model.TemplateInstanceBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endTemplateInstanceExtension() {
      return and();
    }
    
  }
  public class BuildExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.BuildFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildExtensionNestedImpl(io.fabric8.openshift.api.model.Build item) {
      this.builder = new io.fabric8.openshift.api.model.BuildBuilder(this, item);
    }
    BuildExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endBuildExtension() {
      return and();
    }
    
  }
  public class RoleBindingRestrictionExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.RoleBindingRestrictionFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleBindingRestrictionExtensionNestedImpl(io.fabric8.openshift.api.model.RoleBindingRestriction item) {
      this.builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endRoleBindingRestrictionExtension() {
      return and();
    }
    
  }
  public class ImageStreamTagExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ImageStreamTagFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamTagExtensionNestedImpl(io.fabric8.openshift.api.model.ImageStreamTag item) {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamTagBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageStreamTagExtension() {
      return and();
    }
    
  }
  public class GroupExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.GroupFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.GroupExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.GroupExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GroupExtensionNestedImpl(io.fabric8.openshift.api.model.Group item) {
      this.builder = new io.fabric8.openshift.api.model.GroupBuilder(this, item);
    }
    GroupExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.GroupBuilder(this);
    }
    io.fabric8.openshift.api.model.GroupBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endGroupExtension() {
      return and();
    }
    
  }
  public class ImageSignatureExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ImageSignatureFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageSignatureExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageSignatureExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageSignatureExtensionNestedImpl(io.fabric8.openshift.api.model.ImageSignature item) {
      this.builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(this, item);
    }
    ImageSignatureExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageSignatureBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageSignatureExtension() {
      return and();
    }
    
  }
  public class HostSubnetExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.HostSubnetFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HostSubnetExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.HostSubnetExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HostSubnetExtensionNestedImpl(io.fabric8.openshift.api.model.HostSubnet item) {
      this.builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(this, item);
    }
    HostSubnetExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(this);
    }
    io.fabric8.openshift.api.model.HostSubnetBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endHostSubnetExtension() {
      return and();
    }
    
  }
  public class AppliedClusterResourceQuotaExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.AppliedClusterResourceQuotaFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AppliedClusterResourceQuotaExtensionNestedImpl(io.fabric8.openshift.api.model.AppliedClusterResourceQuota item) {
      this.builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(this);
    }
    io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endAppliedClusterResourceQuotaExtension() {
      return and();
    }
    
  }
  public class SecurityContextConstraintsExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SecurityContextConstraintsExtensionNestedImpl(io.fabric8.openshift.api.model.SecurityContextConstraints item) {
      this.builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(this);
    }
    io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endSecurityContextConstraintsExtension() {
      return and();
    }
    
  }
  public class ConsoleExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ConsoleFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConsoleExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConsoleExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConsoleExtensionNestedImpl(io.fabric8.openshift.api.model.Console item) {
      this.builder = new io.fabric8.openshift.api.model.ConsoleBuilder(this, item);
    }
    ConsoleExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ConsoleBuilder(this);
    }
    io.fabric8.openshift.api.model.ConsoleBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endConsoleExtension() {
      return and();
    }
    
  }
  public class BuildRequestExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.BuildRequestFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildRequestExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildRequestExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildRequestExtensionNestedImpl(io.fabric8.openshift.api.model.BuildRequest item) {
      this.builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(this, item);
    }
    BuildRequestExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildRequestBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endBuildRequestExtension() {
      return and();
    }
    
  }
  public class EgressNetworkPolicyExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.EgressNetworkPolicyFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EgressNetworkPolicyExtensionNestedImpl(io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
      this.builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endEgressNetworkPolicyExtension() {
      return and();
    }
    
  }
  public class NetNamespaceExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.NetNamespaceFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetNamespaceExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetNamespaceExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NetNamespaceExtensionNestedImpl(io.fabric8.openshift.api.model.NetNamespace item) {
      this.builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(this, item);
    }
    NetNamespaceExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(this);
    }
    io.fabric8.openshift.api.model.NetNamespaceBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endNetNamespaceExtension() {
      return and();
    }
    
  }
  public class UserIdentityMappingExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.UserIdentityMappingFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserIdentityMappingExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserIdentityMappingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserIdentityMappingExtensionNestedImpl(io.fabric8.openshift.api.model.UserIdentityMapping item) {
      this.builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(this);
    }
    io.fabric8.openshift.api.model.UserIdentityMappingBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endUserIdentityMappingExtension() {
      return and();
    }
    
  }
  public class ImageStreamExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.ImageStreamFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamExtensionNestedImpl(io.fabric8.openshift.api.model.ImageStream item) {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(this, item);
    }
    ImageStreamExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endImageStreamExtension() {
      return and();
    }
    
  }
  public class NetworkExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.NetworkFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetworkExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetworkExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NetworkExtensionNestedImpl(io.fabric8.openshift.api.model.Network item) {
      this.builder = new io.fabric8.openshift.api.model.NetworkBuilder(this, item);
    }
    NetworkExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.NetworkBuilder(this);
    }
    io.fabric8.openshift.api.model.NetworkBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endNetworkExtension() {
      return and();
    }
    
  }
  public class OAuthClientExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthClientFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthClientExtensionNestedImpl(io.fabric8.openshift.api.model.OAuthClient item) {
      this.builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(this, item);
    }
    OAuthClientExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthClientBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endOAuthClientExtension() {
      return and();
    }
    
  }
  public class IdentityExtensionNestedImpl<N> extends io.fabric8.openshift.api.model.IdentityFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IdentityExtensionNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IdentityExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IdentityExtensionNestedImpl(io.fabric8.openshift.api.model.Identity item) {
      this.builder = new io.fabric8.openshift.api.model.IdentityBuilder(this, item);
    }
    IdentityExtensionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.IdentityBuilder(this);
    }
    io.fabric8.openshift.api.model.IdentityBuilder builder;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
    }
    public N endIdentityExtension() {
      return and();
    }
    
  }
  public class RelatedObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RelatedObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(this, item);
    }
    RelatedObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.ObjectReferenceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToRelatedObjects(index,builder.build());
    }
    public N endRelatedObject() {
      return and();
    }
    
  }
  public class VersionsNestedImpl<N> extends io.fabric8.openshift.api.model.OperandVersionFluentImpl<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<N>> implements io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VersionsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.OperandVersion item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(this, item);
    }
    VersionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.OperandVersionBuilder(this);
    }
    io.fabric8.openshift.api.model.OperandVersionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToVersions(index,builder.build());
    }
    public N endVersion() {
      return and();
    }
    
  }
  
}