package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterVersionBuilder extends io.fabric8.openshift.api.model.ClusterVersionFluentImpl<io.fabric8.openshift.api.model.ClusterVersionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ClusterVersion,io.fabric8.openshift.api.model.ClusterVersionBuilder>{
  public ClusterVersionBuilder() {
    this(false);
  }
  public ClusterVersionBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterVersion(), validationEnabled);
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterVersion(), validationEnabled);
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersionFluent<?> fluent,io.fabric8.openshift.api.model.ClusterVersion instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersionFluent<?> fluent,io.fabric8.openshift.api.model.ClusterVersion instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersion instance) {
    this(instance,false);
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersion instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterVersionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterVersion build() {
    ClusterVersion buildable = new ClusterVersion(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterVersionBuilder that = (ClusterVersionBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}