package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ImageStreamBuilder extends io.fabric8.openshift.api.model.ImageStreamFluentImpl<io.fabric8.openshift.api.model.ImageStreamBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageStream,io.fabric8.openshift.api.model.ImageStreamBuilder>{
  public ImageStreamBuilder() {
    this(false);
  }
  public ImageStreamBuilder(java.lang.Boolean validationEnabled) {
    this(new ImageStream(), validationEnabled);
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStreamFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStreamFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStream(), validationEnabled);
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStreamFluent<?> fluent,io.fabric8.openshift.api.model.ImageStream instance) {
    this(fluent, instance, false);
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStreamFluent<?> fluent,io.fabric8.openshift.api.model.ImageStream instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStream instance) {
    this(instance,false);
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStream instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStream build() {
    ImageStream buildable = new ImageStream(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStreamBuilder that = (ImageStreamBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}