package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class RoleFluentImpl<A extends io.fabric8.openshift.api.model.RoleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.RoleFluent<A>{
  public RoleFluentImpl() {
  }
  public RoleFluentImpl(io.fabric8.openshift.api.model.Role instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRules(instance.getRules()); 
  }
  private java.lang.String apiVersion;
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private java.util.List<io.fabric8.openshift.api.model.PolicyRuleBuilder> rules =  new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>();
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.openshift.api.model.RoleFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.openshift.api.model.RoleFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.RoleFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.openshift.api.model.RoleFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.RoleFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.RoleFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.RoleFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToRules(java.lang.Integer index,io.fabric8.openshift.api.model.PolicyRule item) {
    if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>();}
    io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
  }
  public A setToRules(java.lang.Integer index,io.fabric8.openshift.api.model.PolicyRule item) {
    if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>();}
    io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
    if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
     return (A)this;
  }
  public A addToRules(io.fabric8.openshift.api.model.PolicyRule... items) {
    if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>();}
    for (io.fabric8.openshift.api.model.PolicyRule item : items) {io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(java.util.Collection<io.fabric8.openshift.api.model.PolicyRule> items) {
    if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>();}
    for (io.fabric8.openshift.api.model.PolicyRule item : items) {io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.fabric8.openshift.api.model.PolicyRule... items) {
    for (io.fabric8.openshift.api.model.PolicyRule item : items) {io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeAllFromRules(java.util.Collection<io.fabric8.openshift.api.model.PolicyRule> items) {
    for (io.fabric8.openshift.api.model.PolicyRule item : items) {io.fabric8.openshift.api.model.PolicyRuleBuilder builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRules(java.util.function.Predicate<io.fabric8.openshift.api.model.PolicyRuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.PolicyRuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.PolicyRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.PolicyRule> getRules() {
    return build(rules);
  }
  public java.util.List<io.fabric8.openshift.api.model.PolicyRule> buildRules() {
    return build(rules);
  }
  public io.fabric8.openshift.api.model.PolicyRule buildRule(java.lang.Integer index) {
    return this.rules.get(index).build();
  }
  public io.fabric8.openshift.api.model.PolicyRule buildFirstRule() {
    return this.rules.get(0).build();
  }
  public io.fabric8.openshift.api.model.PolicyRule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.PolicyRule buildMatchingRule(java.util.function.Predicate<io.fabric8.openshift.api.model.PolicyRuleBuilder> predicate) {
    for (io.fabric8.openshift.api.model.PolicyRuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRule(java.util.function.Predicate<io.fabric8.openshift.api.model.PolicyRuleBuilder> predicate) {
    for (io.fabric8.openshift.api.model.PolicyRuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRules(java.util.List<io.fabric8.openshift.api.model.PolicyRule> rules) {
    if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
    if (rules != null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.PolicyRuleBuilder>(); for (io.fabric8.openshift.api.model.PolicyRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  public A withRules(io.fabric8.openshift.api.model.PolicyRule... rules) {
    if (this.rules != null) {this.rules.clear();}
    if (rules != null) {for (io.fabric8.openshift.api.model.PolicyRule item :rules){ this.addToRules(item);}} return (A) this;
  }
  public java.lang.Boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public io.fabric8.openshift.api.model.RoleFluent.RulesNested<A> addNewRule() {
    return new io.fabric8.openshift.api.model.RoleFluentImpl.RulesNestedImpl();
  }
  public io.fabric8.openshift.api.model.RoleFluent.RulesNested<A> addNewRuleLike(io.fabric8.openshift.api.model.PolicyRule item) {
    return new io.fabric8.openshift.api.model.RoleFluentImpl.RulesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.RoleFluent.RulesNested<A> setNewRuleLike(java.lang.Integer index,io.fabric8.openshift.api.model.PolicyRule item) {
    return new io.fabric8.openshift.api.model.RoleFluentImpl.RulesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.RoleFluent.RulesNested<A> editRule(java.lang.Integer index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public io.fabric8.openshift.api.model.RoleFluent.RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public io.fabric8.openshift.api.model.RoleFluent.RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public io.fabric8.openshift.api.model.RoleFluent.RulesNested<A> editMatchingRule(java.util.function.Predicate<io.fabric8.openshift.api.model.PolicyRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RoleFluentImpl that = (RoleFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  rules,  super.hashCode());
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.RoleFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.RoleFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) RoleFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class RulesNestedImpl<N> extends io.fabric8.openshift.api.model.PolicyRuleFluentImpl<io.fabric8.openshift.api.model.RoleFluent.RulesNested<N>> implements io.fabric8.openshift.api.model.RoleFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RulesNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.PolicyRule item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(this, item);
    }
    RulesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.PolicyRuleBuilder(this);
    }
    io.fabric8.openshift.api.model.PolicyRuleBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) RoleFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  
}