package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class TokenConfigBuilder extends io.fabric8.openshift.api.model.TokenConfigFluentImpl<io.fabric8.openshift.api.model.TokenConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.TokenConfig,io.fabric8.openshift.api.model.TokenConfigBuilder>{
  public TokenConfigBuilder() {
    this(false);
  }
  public TokenConfigBuilder(java.lang.Boolean validationEnabled) {
    this(new TokenConfig(), validationEnabled);
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TokenConfig(), validationEnabled);
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfigFluent<?> fluent,io.fabric8.openshift.api.model.TokenConfig instance) {
    this(fluent, instance, false);
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfigFluent<?> fluent,io.fabric8.openshift.api.model.TokenConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout()); 
    fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
    fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
    this.validationEnabled = validationEnabled; 
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfig instance) {
    this(instance,false);
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout()); 
    this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
    this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.TokenConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.TokenConfig build() {
    TokenConfig buildable = new TokenConfig(fluent.getAccessTokenInactivityTimeout(),fluent.getAccessTokenInactivityTimeoutSeconds(),fluent.getAccessTokenMaxAgeSeconds());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TokenConfigBuilder that = (TokenConfigBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}