/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.api.model.RouteSpecFluentImpl;
import java.util.Objects;

public class RouteSpecBuilder
extends RouteSpecFluentImpl<RouteSpecBuilder>
implements VisitableBuilder<RouteSpec, RouteSpecBuilder> {
    RouteSpecFluent<?> fluent;
    Boolean validationEnabled;

    public RouteSpecBuilder() {
        this(false);
    }

    public RouteSpecBuilder(Boolean validationEnabled) {
        this(new RouteSpec(), validationEnabled);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RouteSpec(), validationEnabled);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, RouteSpec instance) {
        this(fluent, instance, false);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, RouteSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAlternateBackends(instance.getAlternateBackends());
        fluent.withHost(instance.getHost());
        fluent.withPath(instance.getPath());
        fluent.withPort(instance.getPort());
        fluent.withSubdomain(instance.getSubdomain());
        fluent.withTls(instance.getTls());
        fluent.withTo(instance.getTo());
        fluent.withWildcardPolicy(instance.getWildcardPolicy());
        this.validationEnabled = validationEnabled;
    }

    public RouteSpecBuilder(RouteSpec instance) {
        this(instance, (Boolean)false);
    }

    public RouteSpecBuilder(RouteSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAlternateBackends(instance.getAlternateBackends());
        this.withHost(instance.getHost());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withSubdomain(instance.getSubdomain());
        this.withTls(instance.getTls());
        this.withTo(instance.getTo());
        this.withWildcardPolicy(instance.getWildcardPolicy());
        this.validationEnabled = validationEnabled;
    }

    public RouteSpec build() {
        RouteSpec buildable = new RouteSpec(this.fluent.getAlternateBackends(), this.fluent.getHost(), this.fluent.getPath(), this.fluent.getPort(), this.fluent.getSubdomain(), this.fluent.getTls(), this.fluent.getTo(), this.fluent.getWildcardPolicy());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteSpecBuilder that = (RouteSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

