package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class BuildStrategyBuilder extends io.fabric8.openshift.api.model.BuildStrategyFluentImpl<io.fabric8.openshift.api.model.BuildStrategyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.BuildStrategy,io.fabric8.openshift.api.model.BuildStrategyBuilder>{
  public BuildStrategyBuilder() {
    this(false);
  }
  public BuildStrategyBuilder(java.lang.Boolean validationEnabled) {
    this(new BuildStrategy(), validationEnabled);
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildStrategy(), validationEnabled);
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.BuildStrategy instance) {
    this(fluent, instance, false);
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.BuildStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCustomStrategy(instance.getCustomStrategy()); 
    fluent.withDockerStrategy(instance.getDockerStrategy()); 
    fluent.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy()); 
    fluent.withSourceStrategy(instance.getSourceStrategy()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategy instance) {
    this(instance,false);
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCustomStrategy(instance.getCustomStrategy()); 
    this.withDockerStrategy(instance.getDockerStrategy()); 
    this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy()); 
    this.withSourceStrategy(instance.getSourceStrategy()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildStrategyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildStrategy build() {
    BuildStrategy buildable = new BuildStrategy(fluent.getCustomStrategy(),fluent.getDockerStrategy(),fluent.getJenkinsPipelineStrategy(),fluent.getSourceStrategy(),fluent.getType());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildStrategyBuilder that = (BuildStrategyBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}