package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class DockerBuildStrategyFluentImpl<A extends io.fabric8.openshift.api.model.DockerBuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.DockerBuildStrategyFluent<A>{
  public DockerBuildStrategyFluentImpl() {
  }
  public DockerBuildStrategyFluentImpl(io.fabric8.openshift.api.model.DockerBuildStrategy instance) {
    this.withBuildArgs(instance.getBuildArgs()); 
    this.withDockerfilePath(instance.getDockerfilePath()); 
    this.withEnv(instance.getEnv()); 
    this.withForcePull(instance.getForcePull()); 
    this.withFrom(instance.getFrom()); 
    this.withImageOptimizationPolicy(instance.getImageOptimizationPolicy()); 
    this.withNoCache(instance.getNoCache()); 
    this.withPullSecret(instance.getPullSecret()); 
  }
  private java.util.List<io.fabric8.kubernetes.api.model.EnvVar> buildArgs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();
  private java.lang.String dockerfilePath;
  private java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();
  private java.lang.Boolean forcePull;
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder from;
  private java.lang.String imageOptimizationPolicy;
  private java.lang.Boolean noCache;
  private io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder pullSecret;
  public A addToBuildArgs(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.buildArgs == null) {this.buildArgs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.buildArgs.add(index, item);
    return (A)this;
  }
  public A setToBuildArgs(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.buildArgs == null) {this.buildArgs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.buildArgs.set(index, item); return (A)this;
  }
  public A addToBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.buildArgs == null) {this.buildArgs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
  }
  public A addAllToBuildArgs(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    if (this.buildArgs == null) {this.buildArgs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
  }
  public A removeFromBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.buildArgs!= null){ this.buildArgs.remove(item);}} return (A)this;
  }
  public A removeAllFromBuildArgs(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.buildArgs!= null){ this.buildArgs.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> getBuildArgs() {
    return this.buildArgs;
  }
  public io.fabric8.kubernetes.api.model.EnvVar getBuildArg(java.lang.Integer index) {
    return this.buildArgs.get(index);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getFirstBuildArg() {
    return this.buildArgs.get(0);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getLastBuildArg() {
    return this.buildArgs.get(buildArgs.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getMatchingBuildArg(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: buildArgs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingBuildArg(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: buildArgs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBuildArgs(java.util.List<io.fabric8.kubernetes.api.model.EnvVar> buildArgs) {
    if (buildArgs != null) {this.buildArgs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>(); for (io.fabric8.kubernetes.api.model.EnvVar item : buildArgs){this.addToBuildArgs(item);}} else { this.buildArgs = null;} return (A) this;
  }
  public A withBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... buildArgs) {
    if (this.buildArgs != null) {this.buildArgs.clear();}
    if (buildArgs != null) {for (io.fabric8.kubernetes.api.model.EnvVar item :buildArgs){ this.addToBuildArgs(item);}} return (A) this;
  }
  public java.lang.Boolean hasBuildArgs() {
    return buildArgs != null && !buildArgs.isEmpty();
  }
  public java.lang.String getDockerfilePath() {
    return this.dockerfilePath;
  }
  public A withDockerfilePath(java.lang.String dockerfilePath) {
    this.dockerfilePath=dockerfilePath; return (A) this;
  }
  public java.lang.Boolean hasDockerfilePath() {
    return this.dockerfilePath != null;
  }
  
  /**
   * Method is deprecated. use withDockerfilePath instead.
   */
  @java.lang.Deprecated
  public A withNewDockerfilePath(java.lang.String arg0) {
    return (A)withDockerfilePath(new String(arg0));
  }
  public A addToEnv(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  public A setToEnv(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A addAllToEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public A removeAllFromEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> getEnv() {
    return this.env;
  }
  public io.fabric8.kubernetes.api.model.EnvVar getEnv(java.lang.Integer index) {
    return this.env.get(index);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env) {
    if (env != null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>(); for (io.fabric8.kubernetes.api.model.EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear();}
    if (env != null) {for (io.fabric8.kubernetes.api.model.EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public java.lang.Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public java.lang.Boolean getForcePull() {
    return this.forcePull;
  }
  public A withForcePull(java.lang.Boolean forcePull) {
    this.forcePull=forcePull; return (A) this;
  }
  public java.lang.Boolean hasForcePull() {
    return this.forcePull != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getFrom() {
    return this.from!=null?this.from.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildFrom() {
    return this.from!=null?this.from.build():null;
  }
  public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} return (A) this;
  }
  public java.lang.Boolean hasFrom() {
    return this.from != null;
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<A> withNewFrom() {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyFluentImpl.FromNestedImpl();
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyFluentImpl.FromNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  public java.lang.String getImageOptimizationPolicy() {
    return this.imageOptimizationPolicy;
  }
  public A withImageOptimizationPolicy(java.lang.String imageOptimizationPolicy) {
    this.imageOptimizationPolicy=imageOptimizationPolicy; return (A) this;
  }
  public java.lang.Boolean hasImageOptimizationPolicy() {
    return this.imageOptimizationPolicy != null;
  }
  
  /**
   * Method is deprecated. use withImageOptimizationPolicy instead.
   */
  @java.lang.Deprecated
  public A withNewImageOptimizationPolicy(java.lang.String arg0) {
    return (A)withImageOptimizationPolicy(new String(arg0));
  }
  public java.lang.Boolean getNoCache() {
    return this.noCache;
  }
  public A withNoCache(java.lang.Boolean noCache) {
    this.noCache=noCache; return (A) this;
  }
  public java.lang.Boolean hasNoCache() {
    return this.noCache != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPullSecret instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.LocalObjectReference getPullSecret() {
    return this.pullSecret!=null?this.pullSecret.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildPullSecret() {
    return this.pullSecret!=null?this.pullSecret.build():null;
  }
  public A withPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
    _visitables.get("pullSecret").remove(this.pullSecret);
    if (pullSecret!=null){ this.pullSecret= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} return (A) this;
  }
  public java.lang.Boolean hasPullSecret() {
    return this.pullSecret != null;
  }
  public A withNewPullSecret(java.lang.String name) {
    return (A)withPullSecret(new LocalObjectReference(name));
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyFluentImpl.PullSecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyFluentImpl.PullSecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
    return withNewPullSecretLike(getPullSecret());
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DockerBuildStrategyFluentImpl that = (DockerBuildStrategyFluentImpl) o;
    if (buildArgs != null ? !buildArgs.equals(that.buildArgs) :that.buildArgs != null) return false;
    if (dockerfilePath != null ? !dockerfilePath.equals(that.dockerfilePath) :that.dockerfilePath != null) return false;
    if (env != null ? !env.equals(that.env) :that.env != null) return false;
    if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
    if (from != null ? !from.equals(that.from) :that.from != null) return false;
    if (imageOptimizationPolicy != null ? !imageOptimizationPolicy.equals(that.imageOptimizationPolicy) :that.imageOptimizationPolicy != null) return false;
    if (noCache != null ? !noCache.equals(that.noCache) :that.noCache != null) return false;
    if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(buildArgs,  dockerfilePath,  env,  forcePull,  from,  imageOptimizationPolicy,  noCache,  pullSecret,  super.hashCode());
  }
  public class FromNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<N>> implements io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FromNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) DockerBuildStrategyFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  public class PullSecretNestedImpl<N> extends io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl<io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<N>> implements io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PullSecretNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
    }
    PullSecretNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) DockerBuildStrategyFluentImpl.this.withPullSecret(builder.build());
    }
    public N endPullSecret() {
      return and();
    }
    
  }
  
}