package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NetworkStatusBuilder extends io.fabric8.openshift.api.model.NetworkStatusFluentImpl<io.fabric8.openshift.api.model.NetworkStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.NetworkStatus,io.fabric8.openshift.api.model.NetworkStatusBuilder>{
  public NetworkStatusBuilder() {
    this(false);
  }
  public NetworkStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new NetworkStatus(), validationEnabled);
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkStatus(), validationEnabled);
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatusFluent<?> fluent,io.fabric8.openshift.api.model.NetworkStatus instance) {
    this(fluent, instance, false);
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatusFluent<?> fluent,io.fabric8.openshift.api.model.NetworkStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterNetwork(instance.getClusterNetwork()); 
    fluent.withClusterNetworkMTU(instance.getClusterNetworkMTU()); 
    fluent.withMigration(instance.getMigration()); 
    fluent.withNetworkType(instance.getNetworkType()); 
    fluent.withServiceNetwork(instance.getServiceNetwork()); 
    this.validationEnabled = validationEnabled; 
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatus instance) {
    this(instance,false);
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withClusterNetworkMTU(instance.getClusterNetworkMTU()); 
    this.withMigration(instance.getMigration()); 
    this.withNetworkType(instance.getNetworkType()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.NetworkStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.NetworkStatus build() {
    NetworkStatus buildable = new NetworkStatus(fluent.getClusterNetwork(),fluent.getClusterNetworkMTU(),fluent.getMigration(),fluent.getNetworkType(),fluent.getServiceNetwork());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkStatusBuilder that = (NetworkStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}