/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.Console;
import io.fabric8.openshift.api.model.ConsoleFluent;
import io.fabric8.openshift.api.model.ConsoleFluentImpl;
import java.util.Objects;

public class ConsoleBuilder
extends ConsoleFluentImpl<ConsoleBuilder>
implements VisitableBuilder<Console, ConsoleBuilder> {
    ConsoleFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleBuilder() {
        this(false);
    }

    public ConsoleBuilder(Boolean validationEnabled) {
        this(new Console(), validationEnabled);
    }

    public ConsoleBuilder(ConsoleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ConsoleBuilder(ConsoleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Console(), validationEnabled);
    }

    public ConsoleBuilder(ConsoleFluent<?> fluent, Console instance) {
        this(fluent, instance, false);
    }

    public ConsoleBuilder(ConsoleFluent<?> fluent, Console instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ConsoleBuilder(Console instance) {
        this(instance, (Boolean)false);
    }

    public ConsoleBuilder(Console instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public Console build() {
        Console buildable = new Console(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsoleBuilder that = (ConsoleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

