package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServerServingCertsBuilder extends APIServerServingCertsFluentImpl<APIServerServingCertsBuilder> implements VisitableBuilder<APIServerServingCerts,io.fabric8.openshift.api.model.APIServerServingCertsBuilder>{
  public APIServerServingCertsBuilder() {
    this(false);
  }
  public APIServerServingCertsBuilder(Boolean validationEnabled) {
    this(new APIServerServingCerts(), validationEnabled);
  }
  public APIServerServingCertsBuilder(APIServerServingCertsFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCertsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIServerServingCerts(), validationEnabled);
  }
  public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCertsFluent<?> fluent,io.fabric8.openshift.api.model.APIServerServingCerts instance) {
    this(fluent, instance, false);
  }
  public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCertsFluent<?> fluent,io.fabric8.openshift.api.model.APIServerServingCerts instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNamedCertificates(instance.getNamedCertificates()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCerts instance) {
    this(instance,false);
  }
  public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCerts instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNamedCertificates(instance.getNamedCertificates()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.APIServerServingCertsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.APIServerServingCerts build() {
    APIServerServingCerts buildable = new APIServerServingCerts(fluent.getNamedCertificates());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}